/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class UpdateConditionAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final QualityGatesWsSupport wsSupport;

    public UpdateConditionAction(DbClient dbClient, QualityGateConditionsUpdater qualityGateConditionsUpdater, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("update_condition").setDescription("Update a condition attached to a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setChangelog(new Change[]{new Change("7.6", "Removed optional 'warning' and 'period' parameters"), new Change("7.6", "Made 'error' parameter mandatory"), new Change("7.6", "Reduced the possible values of 'op' parameter to LT and GT")}).setHandler((RequestHandler)this);
        createCondition.createParam("id").setDescription("Condition ID").setRequired(true).setExampleValue((Object)"10");
        QualityGatesWs.addConditionParams(createCondition);
        this.wsSupport.createOrganizationParam(createCondition);
    }

    public void handle(Request request, Response response) {
        int id = request.mandatoryParamAsInt("id");
        String metric = request.mandatoryParam("metric");
        String operator = request.mandatoryParam("op");
        String error = request.mandatoryParam("error");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QualityGateConditionDto condition = this.wsSupport.getCondition(dbSession, id);
            QGateWithOrgDto qualityGateDto = this.dbClient.qualityGateDao().selectByOrganizationAndId(dbSession, organization, condition.getQualityGateId());
            Preconditions.checkState((qualityGateDto != null ? 1 : 0) != 0, (String)"Condition '%s' is linked to an unknown quality gate '%s'", (Object[])new Object[]{id, condition.getQualityGateId()});
            this.wsSupport.checkCanEdit(qualityGateDto);
            QualityGateConditionDto updatedCondition = this.qualityGateConditionsUpdater.updateCondition(dbSession, condition, metric, operator, error);
            Qualitygates.UpdateConditionResponse.Builder updateConditionResponse = Qualitygates.UpdateConditionResponse.newBuilder().setId(updatedCondition.getId()).setMetric(updatedCondition.getMetricKey()).setError(updatedCondition.getErrorThreshold()).setOp(updatedCondition.getOperator());
            WsUtils.writeProtobuf((Message)updateConditionResponse.build(), request, response);
            dbSession.commit();
        }
    }
}

