/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.DefaultQProfileDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualityprofile.QProfileFactory;
import org.sonar.server.qualityprofile.QProfileName;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.ws.WsUtils;

public class QProfileFactoryImpl
implements QProfileFactory {
    private final DbClient db;
    private final UuidFactory uuidFactory;
    private final System2 system2;
    private final ActiveRuleIndexer activeRuleIndexer;

    public QProfileFactoryImpl(DbClient db, UuidFactory uuidFactory, System2 system2, ActiveRuleIndexer activeRuleIndexer) {
        this.db = db;
        this.uuidFactory = uuidFactory;
        this.system2 = system2;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    private static OrganizationDto requireNonNull(@Nullable OrganizationDto organization) {
        Objects.requireNonNull(organization, "Organization is required, when creating a quality profile.");
        return organization;
    }

    @Override
    public QProfileDto getOrCreateCustom(DbSession dbSession, OrganizationDto organization, QProfileName name) {
        QProfileFactoryImpl.requireNonNull(organization);
        QProfileDto profile = this.db.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, name.getName(), name.getLanguage());
        if (profile == null) {
            profile = this.doCreate(dbSession, organization, name, false, false);
        } else {
            Preconditions.checkArgument((!profile.isBuiltIn() ? 1 : 0) != 0, (String)"Operation forbidden for built-in Quality Profile '%s' with language '%s'", (Object[])new Object[]{profile.getName(), profile.getLanguage()});
        }
        return profile;
    }

    @Override
    public QProfileDto checkAndCreateCustom(DbSession dbSession, OrganizationDto organization, QProfileName name) {
        QProfileFactoryImpl.requireNonNull(organization);
        QProfileDto dto = this.db.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, name.getName(), name.getLanguage());
        WsUtils.checkRequest(dto == null, "Quality profile already exists: %s", name);
        return this.doCreate(dbSession, organization, name, false, false);
    }

    private QProfileDto doCreate(DbSession dbSession, OrganizationDto organization, QProfileName name, boolean isDefault, boolean isBuiltIn) {
        if (StringUtils.isEmpty((String)name.getName())) {
            throw BadRequestException.create("quality_profiles.profile_name_cant_be_blank");
        }
        Date now = new Date(this.system2.now());
        QProfileDto dto = new QProfileDto().setKee(this.uuidFactory.create()).setRulesProfileUuid(this.uuidFactory.create()).setName(name.getName()).setOrganizationUuid(organization.getUuid()).setLanguage(name.getLanguage()).setIsBuiltIn(isBuiltIn).setRulesUpdatedAtAsDate(now);
        this.db.qualityProfileDao().insert(dbSession, dto, new QProfileDto[0]);
        if (isDefault) {
            this.db.defaultQProfileDao().insertOrUpdate(dbSession, DefaultQProfileDto.from((QProfileDto)dto));
        }
        return dto;
    }

    @Override
    public void delete(DbSession dbSession, Collection<QProfileDto> profiles) {
        if (profiles.isEmpty()) {
            return;
        }
        HashSet uuids = new HashSet();
        ArrayList customProfiles = new ArrayList();
        HashSet rulesProfileUuidsOfCustomProfiles = new HashSet();
        profiles.forEach(p -> {
            uuids.add(p.getKee());
            if (!p.isBuiltIn()) {
                customProfiles.add(p);
                rulesProfileUuidsOfCustomProfiles.add(p.getRulesProfileUuid());
            }
        });
        this.db.qualityProfileDao().deleteProjectAssociationsByProfileUuids(dbSession, uuids);
        this.db.defaultQProfileDao().deleteByQProfileUuids(dbSession, uuids);
        this.db.qualityProfileDao().deleteOrgQProfilesByUuids(dbSession, uuids);
        this.db.qProfileEditUsersDao().deleteByQProfiles(dbSession, customProfiles);
        this.db.qProfileEditGroupsDao().deleteByQProfiles(dbSession, customProfiles);
        if (!rulesProfileUuidsOfCustomProfiles.isEmpty()) {
            this.db.activeRuleDao().deleteParametersByRuleProfileUuids(dbSession, rulesProfileUuidsOfCustomProfiles);
            this.db.activeRuleDao().deleteByRuleProfileUuids(dbSession, rulesProfileUuidsOfCustomProfiles);
            this.db.qProfileChangeDao().deleteByRulesProfileUuids(dbSession, rulesProfileUuidsOfCustomProfiles);
            this.db.qualityProfileDao().deleteRulesProfilesByUuids(dbSession, rulesProfileUuidsOfCustomProfiles);
            this.activeRuleIndexer.commitDeletionOfProfiles(dbSession, customProfiles);
        } else {
            dbSession.commit();
        }
    }
}

