/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.root.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.root.ws.RootsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class UnsetRootAction
implements RootsWsAction {
    private static final String PARAM_LOGIN = "login";
    private final UserSession userSession;
    private final DbClient dbClient;

    public UnsetRootAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("unset_root").setInternal(true).setPost(true).setDescription("Make the specified user not root.<br/>Requires to be root.").setSince("6.2").setHandler((RequestHandler)this);
        action.createParam(PARAM_LOGIN).setDescription("A user login").setExampleValue((Object)"admin").setRequired(true).setSince("6.2");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsRoot();
        String login = request.mandatoryParam(PARAM_LOGIN);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.dbClient.userDao().selectByLogin(dbSession, login);
            if (userDto == null || !userDto.isActive()) {
                throw new NotFoundException(String.format("User with login '%s' not found", login));
            }
            WsUtils.checkRequest(this.dbClient.userDao().countRootUsersButLogin(dbSession, login) > 0L, "Last root can't be unset", new Object[0]);
            if (userDto.isRoot()) {
                this.dbClient.userDao().setRoot(dbSession, login, false);
                dbSession.commit();
            }
        }
        response.noContent();
    }
}

