/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RuleRepository;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.i18n.RuleI18nManager;
import org.sonar.server.debt.DebtModelPluginRepository;
import org.sonar.server.debt.DebtModelXMLExporter;
import org.sonar.server.debt.DebtRulesXMLImporter;
import org.sonar.server.plugins.ServerPluginRepository;

@ServerSide
public class DeprecatedRulesDefinitionLoader {
    private static final Logger LOG = Loggers.get(DeprecatedRulesDefinitionLoader.class);
    private final RuleI18nManager i18n;
    private final RuleRepository[] repositories;
    private final DebtModelPluginRepository languageModelFinder;
    private final DebtRulesXMLImporter importer;
    private final ServerPluginRepository serverPluginRepository;

    public DeprecatedRulesDefinitionLoader(RuleI18nManager i18n, DebtModelPluginRepository languageModelFinder, DebtRulesXMLImporter importer, ServerPluginRepository serverPluginRepository, RuleRepository[] repositories) {
        this.i18n = i18n;
        this.serverPluginRepository = serverPluginRepository;
        this.repositories = repositories;
        this.languageModelFinder = languageModelFinder;
        this.importer = importer;
    }

    public DeprecatedRulesDefinitionLoader(RuleI18nManager i18n, DebtModelPluginRepository languageModelFinder, DebtRulesXMLImporter importer, ServerPluginRepository serverPluginRepository) {
        this(i18n, languageModelFinder, importer, serverPluginRepository, new RuleRepository[0]);
    }

    void complete(RulesDefinition.Context context) {
        List<DebtModelXMLExporter.RuleDebt> ruleDebts = this.loadRuleDebtList();
        for (RuleRepository repository : this.repositories) {
            RulesDefinition.NewRepository newRepository;
            context.setCurrentPluginKey(this.serverPluginRepository.getPluginKey(repository));
            if (context.repository(repository.getKey()) == null) {
                newRepository = context.createRepository(repository.getKey(), repository.getLanguage());
                newRepository.setName(repository.getName());
            } else {
                newRepository = context.extendRepository(repository.getKey(), repository.getLanguage());
            }
            for (Rule rule : repository.createRules()) {
                RulesDefinition.NewRule newRule = newRepository.createRule(rule.getKey());
                newRule.setName(this.ruleName(repository.getKey(), rule));
                newRule.setHtmlDescription(this.ruleDescription(repository.getKey(), rule));
                newRule.setInternalKey(rule.getConfigKey());
                newRule.setTemplate(rule.isTemplate());
                newRule.setSeverity(rule.getSeverity().toString());
                newRule.setStatus(rule.getStatus() == null ? RuleStatus.defaultStatus() : RuleStatus.valueOf((String)rule.getStatus()));
                newRule.setTags(rule.getTags());
                for (RuleParam param : rule.getParams()) {
                    RulesDefinition.NewParam newParam = newRule.createParam(param.getKey());
                    newParam.setDefaultValue(param.getDefaultValue());
                    newParam.setDescription(this.paramDescription(repository.getKey(), rule.getKey(), param));
                    newParam.setType(RuleParamType.parse((String)param.getType()));
                }
                DeprecatedRulesDefinitionLoader.updateRuleDebtDefinitions(newRule, repository.getKey(), rule.getKey(), ruleDebts);
            }
            newRepository.done();
        }
    }

    private static void updateRuleDebtDefinitions(RulesDefinition.NewRule newRule, String repoKey, String ruleKey, List<DebtModelXMLExporter.RuleDebt> ruleDebts) {
        DebtModelXMLExporter.RuleDebt ruleDebt = DeprecatedRulesDefinitionLoader.findRequirement(ruleDebts, repoKey, ruleKey);
        if (ruleDebt != null) {
            newRule.setDebtRemediationFunction(DeprecatedRulesDefinitionLoader.remediationFunction(DebtRemediationFunction.Type.valueOf((String)ruleDebt.function()), ruleDebt.coefficient(), ruleDebt.offset(), newRule.debtRemediationFunctions(), repoKey, ruleKey));
        }
    }

    private static DebtRemediationFunction remediationFunction(DebtRemediationFunction.Type function, @Nullable String coefficient, @Nullable String offset, RulesDefinition.DebtRemediationFunctions functions, String repoKey, String ruleKey) {
        if (DebtRemediationFunction.Type.LINEAR.equals((Object)function) && coefficient != null) {
            return functions.linear(coefficient);
        }
        if (DebtRemediationFunction.Type.CONSTANT_ISSUE.equals((Object)function) && offset != null) {
            return functions.constantPerIssue(offset);
        }
        if (DebtRemediationFunction.Type.LINEAR_OFFSET.equals((Object)function) && coefficient != null && offset != null) {
            return functions.linearWithOffset(coefficient, offset);
        }
        throw new IllegalArgumentException(String.format("Debt definition on rule '%s:%s' is invalid", repoKey, ruleKey));
    }

    @CheckForNull
    private String ruleName(String repositoryKey, Rule rule) {
        String name = this.i18n.getName(repositoryKey, rule.getKey());
        if (StringUtils.isNotBlank((String)name)) {
            return name;
        }
        return StringUtils.defaultIfBlank((String)rule.getName(), null);
    }

    @CheckForNull
    private String ruleDescription(String repositoryKey, Rule rule) {
        String description = this.i18n.getDescription(repositoryKey, rule.getKey());
        if (StringUtils.isNotBlank((String)description)) {
            return description;
        }
        return StringUtils.defaultIfBlank((String)rule.getDescription(), null);
    }

    @CheckForNull
    private String paramDescription(String repositoryKey, String ruleKey, RuleParam param) {
        String desc = StringUtils.defaultIfEmpty((String)this.i18n.getParamDescription(repositoryKey, ruleKey, param.getKey()), (String)param.getDescription());
        return StringUtils.defaultIfBlank((String)desc, null);
    }

    public List<DebtModelXMLExporter.RuleDebt> loadRuleDebtList() {
        ArrayList ruleDebtList = Lists.newArrayList();
        for (String pluginKey : this.getContributingPluginListWithoutSqale()) {
            ruleDebtList.addAll(this.loadRuleDebtsFromXml(pluginKey));
        }
        return ruleDebtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DebtModelXMLExporter.RuleDebt> loadRuleDebtsFromXml(String pluginKey) {
        List<DebtModelXMLExporter.RuleDebt> list;
        Reader xmlFileReader = null;
        try {
            xmlFileReader = this.languageModelFinder.createReaderForXMLFile(pluginKey);
            ValidationMessages validationMessages = ValidationMessages.create();
            List<DebtModelXMLExporter.RuleDebt> rules = this.importer.importXML(xmlFileReader, validationMessages);
            validationMessages.log(LOG);
            list = rules;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xmlFileReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)xmlFileReader);
        return list;
    }

    private Collection<String> getContributingPluginListWithoutSqale() {
        ArrayList pluginList = Lists.newArrayList(this.languageModelFinder.getContributingPluginList());
        pluginList.remove("technical-debt");
        return pluginList;
    }

    @CheckForNull
    private static DebtModelXMLExporter.RuleDebt findRequirement(List<DebtModelXMLExporter.RuleDebt> requirements, String repoKey, String ruleKey) {
        return (DebtModelXMLExporter.RuleDebt)Iterables.find(requirements, (Predicate)new RuleDebtMatchRepoKeyAndRuleKey(repoKey, ruleKey), null);
    }

    private static class RuleDebtMatchRepoKeyAndRuleKey
    implements Predicate<DebtModelXMLExporter.RuleDebt> {
        private final String repoKey;
        private final String ruleKey;

        public RuleDebtMatchRepoKeyAndRuleKey(String repoKey, String ruleKey) {
            this.repoKey = repoKey;
            this.ruleKey = ruleKey;
        }

        public boolean apply(@Nonnull DebtModelXMLExporter.RuleDebt input) {
            return input.ruleKey().equals((Object)RuleKey.of((String)this.repoKey, (String)this.ruleKey));
        }
    }
}

