/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.rule.DeprecatedRuleKeyDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.db.rule.RuleRepositoryDto;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.QProfileRules;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.rule.RuleDefinitionsLoader;
import org.sonar.server.rule.SingleDeprecatedRuleKey;
import org.sonar.server.rule.WebServerRuleFinder;
import org.sonar.server.rule.index.RuleIndexer;

public class RegisterRules
implements Startable {
    private static final Logger LOG = Loggers.get(RegisterRules.class);
    private final RuleDefinitionsLoader defLoader;
    private final QProfileRules qProfileRules;
    private final DbClient dbClient;
    private final RuleIndexer ruleIndexer;
    private final ActiveRuleIndexer activeRuleIndexer;
    private final Languages languages;
    private final System2 system2;
    private final OrganizationFlags organizationFlags;
    private final WebServerRuleFinder webServerRuleFinder;
    private final UuidFactory uuidFactory;

    public RegisterRules(RuleDefinitionsLoader defLoader, QProfileRules qProfileRules, DbClient dbClient, RuleIndexer ruleIndexer, ActiveRuleIndexer activeRuleIndexer, Languages languages, System2 system2, OrganizationFlags organizationFlags, WebServerRuleFinder webServerRuleFinder, UuidFactory uuidFactory) {
        this.defLoader = defLoader;
        this.qProfileRules = qProfileRules;
        this.dbClient = dbClient;
        this.ruleIndexer = ruleIndexer;
        this.activeRuleIndexer = activeRuleIndexer;
        this.languages = languages;
        this.system2 = system2;
        this.organizationFlags = organizationFlags;
        this.webServerRuleFinder = webServerRuleFinder;
        this.uuidFactory = uuidFactory;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Register rules");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            RulesDefinition.Context ruleDefinitionContext = this.defLoader.load();
            List<RulesDefinition.ExtendedRepository> repositories = RegisterRules.getRepositories(ruleDefinitionContext);
            RegisterRulesContext registerRulesContext = this.createRegisterRulesContext(dbSession);
            RegisterRules.verifyRuleKeyConsistency(repositories, registerRulesContext);
            boolean orgsEnabled = this.organizationFlags.isEnabled(dbSession);
            for (RulesDefinition.ExtendedRepository repoDef : repositories) {
                if (this.languages.get(repoDef.language()) == null) continue;
                for (RulesDefinition.Rule ruleDef : repoDef.rules()) {
                    if (RegisterRules.noTemplateRuleWithOrganizationsEnabled(registerRulesContext, orgsEnabled, ruleDef)) continue;
                    this.registerRule(registerRulesContext, ruleDef, dbSession);
                }
                dbSession.commit();
            }
            this.processRemainingDbRules(registerRulesContext, dbSession);
            List<ActiveRuleChange> changes = this.removeActiveRulesOnStillExistingRepositories(dbSession, registerRulesContext, repositories);
            dbSession.commit();
            this.persistRepositories(dbSession, ruleDefinitionContext.repositories());
            this.ruleIndexer.commitAndIndex(dbSession, (Collection)registerRulesContext.getAllModified().map(RuleDefinitionDto::getId).collect(MoreCollectors.toSet()));
            this.activeRuleIndexer.commitAndIndex(dbSession, changes);
            registerRulesContext.getRenamed().forEach(e -> LOG.info("Rule {} re-keyed to {}", e.getValue(), (Object)((RuleDefinitionDto)e.getKey()).getKey()));
            profiler.stopDebug();
            this.webServerRuleFinder.startCaching();
        }
    }

    private static List<RulesDefinition.ExtendedRepository> getRepositories(RulesDefinition.Context context) {
        ArrayList<RulesDefinition.ExtendedRepository> repositories = new ArrayList<RulesDefinition.ExtendedRepository>(context.repositories());
        for (RulesDefinition.ExtendedRepository extendedRepoDef : context.extendedRepositories()) {
            if (context.repository(extendedRepoDef.key()) == null) {
                LOG.warn(String.format("Extension is ignored, repository %s does not exist", extendedRepoDef.key()));
                continue;
            }
            repositories.add(extendedRepoDef);
        }
        return repositories;
    }

    private RegisterRulesContext createRegisterRulesContext(DbSession dbSession) {
        Map allRules = (Map)this.dbClient.ruleDao().selectAllDefinitions(dbSession).stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getKey));
        Map<Integer, Set<SingleDeprecatedRuleKey>> existingDeprecatedKeysById = this.loadDeprecatedRuleKeys(dbSession);
        return new RegisterRulesContext(allRules, existingDeprecatedKeysById);
    }

    private Map<Integer, Set<SingleDeprecatedRuleKey>> loadDeprecatedRuleKeys(DbSession dbSession) {
        return this.dbClient.ruleDao().selectAllDeprecatedRuleKeys(dbSession).stream().map(SingleDeprecatedRuleKey::from).collect(Collectors.groupingBy(SingleDeprecatedRuleKey::getRuleId, Collectors.toSet()));
    }

    private static boolean noTemplateRuleWithOrganizationsEnabled(RegisterRulesContext registerRulesContext, boolean orgsEnabled, RulesDefinition.Rule ruleDef) {
        if (!ruleDef.template() || !orgsEnabled) {
            return false;
        }
        Optional dbRule = registerRulesContext.getDbRuleFor(ruleDef);
        if (dbRule.isPresent() && ((RuleDefinitionDto)dbRule.get()).getStatus() == RuleStatus.REMOVED) {
            RuleDefinitionDto dto = (RuleDefinitionDto)dbRule.get();
            LOG.debug("Template rule {} kept removed, because organizations are enabled.", (Object)dto.getKey());
            registerRulesContext.removed(dto);
        } else {
            LOG.info("Template rule {} will not be imported, because organizations are enabled.", (Object)RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key()));
        }
        return true;
    }

    private void persistRepositories(DbSession dbSession, List<RulesDefinition.Repository> repositories) {
        List dtos = (List)repositories.stream().map(r -> new RuleRepositoryDto(r.key(), r.language(), r.name())).collect(MoreCollectors.toList((int)repositories.size()));
        List keys = (List)dtos.stream().map(RuleRepositoryDto::getKey).collect(MoreCollectors.toList((int)repositories.size()));
        this.dbClient.ruleRepositoryDao().insertOrUpdate(dbSession, (Collection)dtos);
        this.dbClient.ruleRepositoryDao().deleteIfKeyNotIn(dbSession, (Collection)keys);
        dbSession.commit();
    }

    public void stop() {
    }

    private void registerRule(RegisterRulesContext context, RulesDefinition.Rule ruleDef, DbSession session) {
        RuleKey ruleKey = RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key());
        RuleDefinitionDto ruleDefinitionDto = context.getDbRuleFor(ruleDef).orElseGet(() -> {
            RuleDefinitionDto newRule = this.createRuleDto(ruleDef, session);
            context.created(newRule);
            return newRule;
        });
        if (!ruleDefinitionDto.getKey().equals((Object)ruleKey)) {
            context.renamed(ruleDefinitionDto);
            ruleDefinitionDto.setRuleKey(ruleKey);
        }
        if (RegisterRules.mergeRule(ruleDef, ruleDefinitionDto)) {
            context.updated(ruleDefinitionDto);
        }
        if (RegisterRules.mergeDebtDefinitions(ruleDef, ruleDefinitionDto)) {
            context.updated(ruleDefinitionDto);
        }
        if (RegisterRules.mergeTags(ruleDef, ruleDefinitionDto)) {
            context.updated(ruleDefinitionDto);
        }
        if (RegisterRules.mergeSecurityStandards(ruleDef, ruleDefinitionDto)) {
            context.updated(ruleDefinitionDto);
        }
        if (context.isUpdated(ruleDefinitionDto) || context.isRenamed(ruleDefinitionDto)) {
            this.update(session, ruleDefinitionDto);
        } else if (!context.isCreated(ruleDefinitionDto)) {
            context.unchanged(ruleDefinitionDto);
        }
        this.mergeParams(ruleDef, ruleDefinitionDto, session);
        this.updateDeprecatedKeys(context, ruleDef, ruleDefinitionDto, session);
    }

    private RuleDefinitionDto createRuleDto(RulesDefinition.Rule ruleDef, DbSession session) {
        RuleDefinitionDto ruleDto = new RuleDefinitionDto().setRuleKey(RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key())).setPluginKey(ruleDef.pluginKey()).setIsTemplate(ruleDef.template()).setConfigKey(ruleDef.internalKey()).setLanguage(ruleDef.repository().language()).setName(ruleDef.name()).setSeverity(ruleDef.severity()).setStatus(ruleDef.status()).setGapDescription(ruleDef.gapDescription()).setSystemTags(ruleDef.tags()).setSecurityStandards(ruleDef.securityStandards()).setType(RuleType.valueOf((String)ruleDef.type().name())).setScope(RegisterRules.toDtoScope(ruleDef.scope())).setIsExternal(ruleDef.repository().isExternal()).setIsAdHoc(false).setCreatedAt(this.system2.now()).setUpdatedAt(this.system2.now());
        if (ruleDef.htmlDescription() != null) {
            ruleDto.setDescription(ruleDef.htmlDescription());
            ruleDto.setDescriptionFormat(RuleDto.Format.HTML);
        } else {
            ruleDto.setDescription(ruleDef.markdownDescription());
            ruleDto.setDescriptionFormat(RuleDto.Format.MARKDOWN);
        }
        DebtRemediationFunction debtRemediationFunction = ruleDef.debtRemediationFunction();
        if (debtRemediationFunction != null) {
            ruleDto.setDefRemediationFunction(debtRemediationFunction.type().name());
            ruleDto.setDefRemediationGapMultiplier(debtRemediationFunction.gapMultiplier());
            ruleDto.setDefRemediationBaseEffort(debtRemediationFunction.baseEffort());
            ruleDto.setGapDescription(ruleDef.gapDescription());
        }
        this.dbClient.ruleDao().insert(session, ruleDto);
        return ruleDto;
    }

    private static RuleDto.Scope toDtoScope(RuleScope scope) {
        switch (scope) {
            case ALL: {
                return RuleDto.Scope.ALL;
            }
            case MAIN: {
                return RuleDto.Scope.MAIN;
            }
            case TEST: {
                return RuleDto.Scope.TEST;
            }
        }
        throw new IllegalArgumentException("Unknown rule scope: " + scope);
    }

    private static boolean mergeRule(RulesDefinition.Rule def, RuleDefinitionDto dto) {
        boolean isTemplate;
        boolean changed = false;
        if (!StringUtils.equals((String)dto.getName(), (String)def.name())) {
            dto.setName(def.name());
            changed = true;
        }
        if (RegisterRules.mergeDescription(def, dto)) {
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getPluginKey(), (String)def.pluginKey())) {
            dto.setPluginKey(def.pluginKey());
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getConfigKey(), (String)def.internalKey())) {
            dto.setConfigKey(def.internalKey());
            changed = true;
        }
        String severity = def.severity();
        if (!ObjectUtils.equals((Object)dto.getSeverityString(), (Object)severity)) {
            dto.setSeverity(severity);
            changed = true;
        }
        if ((isTemplate = def.template()) != dto.isTemplate()) {
            dto.setIsTemplate(isTemplate);
            changed = true;
        }
        if (def.status() != dto.getStatus()) {
            dto.setStatus(def.status());
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getScope().name(), (String)def.scope().name())) {
            dto.setScope(RegisterRules.toDtoScope(def.scope()));
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getLanguage(), (String)def.repository().language())) {
            dto.setLanguage(def.repository().language());
            changed = true;
        }
        RuleType type = RuleType.valueOf((String)def.type().name());
        if (!ObjectUtils.equals((Object)dto.getType(), (Object)type.getDbConstant())) {
            dto.setType(type);
            changed = true;
        }
        if (dto.isAdHoc()) {
            dto.setIsAdHoc(false);
            changed = true;
        }
        return changed;
    }

    private static boolean mergeDescription(RulesDefinition.Rule def, RuleDefinitionDto dto) {
        boolean changed = false;
        if (def.htmlDescription() != null && !StringUtils.equals((String)dto.getDescription(), (String)def.htmlDescription())) {
            dto.setDescription(def.htmlDescription());
            dto.setDescriptionFormat(RuleDto.Format.HTML);
            changed = true;
        } else if (def.markdownDescription() != null && !StringUtils.equals((String)dto.getDescription(), (String)def.markdownDescription())) {
            dto.setDescription(def.markdownDescription());
            dto.setDescriptionFormat(RuleDto.Format.MARKDOWN);
            changed = true;
        }
        return changed;
    }

    private static boolean mergeDebtDefinitions(RulesDefinition.Rule def, RuleDefinitionDto dto) {
        boolean hasDebt;
        DebtRemediationFunction debtRemediationFunction = def.debtRemediationFunction();
        boolean bl = hasDebt = debtRemediationFunction != null;
        if (hasDebt) {
            return RegisterRules.mergeDebtDefinitions(dto, debtRemediationFunction.type().name(), debtRemediationFunction.gapMultiplier(), debtRemediationFunction.baseEffort(), def.gapDescription());
        }
        return RegisterRules.mergeDebtDefinitions(dto, null, null, null, null);
    }

    private static boolean mergeDebtDefinitions(RuleDefinitionDto dto, @Nullable String remediationFunction, @Nullable String remediationCoefficient, @Nullable String remediationOffset, @Nullable String effortToFixDescription) {
        boolean changed = false;
        if (!StringUtils.equals((String)dto.getDefRemediationFunction(), (String)remediationFunction)) {
            dto.setDefRemediationFunction(remediationFunction);
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getDefRemediationGapMultiplier(), (String)remediationCoefficient)) {
            dto.setDefRemediationGapMultiplier(remediationCoefficient);
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getDefRemediationBaseEffort(), (String)remediationOffset)) {
            dto.setDefRemediationBaseEffort(remediationOffset);
            changed = true;
        }
        if (!StringUtils.equals((String)dto.getGapDescription(), (String)effortToFixDescription)) {
            dto.setGapDescription(effortToFixDescription);
            changed = true;
        }
        return changed;
    }

    private void mergeParams(RulesDefinition.Rule ruleDef, RuleDefinitionDto rule, DbSession session) {
        List paramDtos = this.dbClient.ruleDao().selectRuleParamsByRuleKey(session, rule.getKey());
        HashMap existingParamsByName = Maps.newHashMap();
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass()));
        for (RuleParamDto paramDto : paramDtos) {
            RulesDefinition.Param paramDef = ruleDef.param(paramDto.getName());
            if (paramDef == null) {
                profiler.start();
                this.dbClient.activeRuleDao().deleteParamsByRuleParamOfAllOrganizations(session, paramDto);
                profiler.stopDebug(String.format("Propagate deleted param with name %s to active rules of rule %s", paramDto.getName(), rule.getKey()));
                this.dbClient.ruleDao().deleteRuleParam(session, paramDto.getId().intValue());
                continue;
            }
            if (RegisterRules.mergeParam(paramDto, paramDef)) {
                this.dbClient.ruleDao().updateRuleParam(session, rule, paramDto);
            }
            existingParamsByName.put(paramDto.getName(), paramDto);
        }
        for (RulesDefinition.Param param : ruleDef.params()) {
            RuleParamDto paramDto = (RuleParamDto)existingParamsByName.get(param.key());
            if (paramDto != null) continue;
            paramDto = RuleParamDto.createFor((RuleDefinitionDto)rule).setName(param.key()).setDescription(param.description()).setDefaultValue(param.defaultValue()).setType(param.type().toString());
            this.dbClient.ruleDao().insertRuleParam(session, rule, paramDto);
            if (StringUtils.isEmpty((String)param.defaultValue())) continue;
            profiler.start();
            for (ActiveRuleDto activeRule : this.dbClient.activeRuleDao().selectByRuleIdOfAllOrganizations(session, rule.getId().intValue())) {
                ActiveRuleParamDto activeParam = ActiveRuleParamDto.createFor((RuleParamDto)paramDto).setValue(param.defaultValue());
                this.dbClient.activeRuleDao().insertParam(session, activeRule, activeParam);
            }
            profiler.stopDebug(String.format("Propagate new param with name %s to active rules of rule %s", paramDto.getName(), rule.getKey()));
        }
    }

    private static boolean mergeParam(RuleParamDto paramDto, RulesDefinition.Param paramDef) {
        boolean changed = false;
        if (!StringUtils.equals((String)paramDto.getType(), (String)paramDef.type().toString())) {
            paramDto.setType(paramDef.type().toString());
            changed = true;
        }
        if (!StringUtils.equals((String)paramDto.getDefaultValue(), (String)paramDef.defaultValue())) {
            paramDto.setDefaultValue(paramDef.defaultValue());
            changed = true;
        }
        if (!StringUtils.equals((String)paramDto.getDescription(), (String)paramDef.description())) {
            paramDto.setDescription(paramDef.description());
            changed = true;
        }
        return changed;
    }

    private void updateDeprecatedKeys(RegisterRulesContext context, RulesDefinition.Rule ruleDef, RuleDefinitionDto rule, DbSession dbSession) {
        Set<SingleDeprecatedRuleKey> deprecatedRuleKeysFromDefinition = SingleDeprecatedRuleKey.from(ruleDef);
        Set deprecatedRuleKeysFromDB = context.getDBDeprecatedKeysFor(rule);
        List uuidsToBeDeleted = (List)Sets.difference((Set)deprecatedRuleKeysFromDB, deprecatedRuleKeysFromDefinition).stream().map(SingleDeprecatedRuleKey::getUuid).collect(MoreCollectors.toList());
        this.dbClient.ruleDao().deleteDeprecatedRuleKeys(dbSession, (Collection)uuidsToBeDeleted);
        Sets.SetView deprecatedRuleKeysToBeCreated = Sets.difference(deprecatedRuleKeysFromDefinition, (Set)deprecatedRuleKeysFromDB);
        deprecatedRuleKeysToBeCreated.forEach(r -> this.dbClient.ruleDao().insert(dbSession, new DeprecatedRuleKeyDto().setUuid(this.uuidFactory.create()).setRuleId(rule.getId()).setOldRepositoryKey(r.getOldRepositoryKey()).setOldRuleKey(r.getOldRuleKey()).setCreatedAt(this.system2.now())));
    }

    private static boolean mergeTags(RulesDefinition.Rule ruleDef, RuleDefinitionDto dto) {
        boolean changed = false;
        if (RuleStatus.REMOVED == ruleDef.status()) {
            dto.setSystemTags(Collections.emptySet());
            changed = true;
        } else if (dto.getSystemTags().size() != ruleDef.tags().size() || !dto.getSystemTags().containsAll(ruleDef.tags())) {
            dto.setSystemTags(ruleDef.tags());
            changed = true;
        }
        return changed;
    }

    private static boolean mergeSecurityStandards(RulesDefinition.Rule ruleDef, RuleDefinitionDto dto) {
        boolean changed = false;
        if (RuleStatus.REMOVED == ruleDef.status()) {
            dto.setSecurityStandards(Collections.emptySet());
            changed = true;
        } else if (dto.getSecurityStandards().size() != ruleDef.securityStandards().size() || !dto.getSecurityStandards().containsAll(ruleDef.securityStandards())) {
            dto.setSecurityStandards(ruleDef.securityStandards());
            changed = true;
        }
        return changed;
    }

    private void processRemainingDbRules(RegisterRulesContext recorder, DbSession dbSession) {
        ArrayList customRules = Lists.newArrayList();
        recorder.getRemaining().forEach(rule -> {
            if (rule.isCustomRule()) {
                customRules.add(rule);
            } else if (!rule.isAdHoc() && rule.getStatus() != RuleStatus.REMOVED) {
                this.removeRule(dbSession, recorder, (RuleDefinitionDto)rule);
            }
        });
        for (RuleDefinitionDto customRule : customRules) {
            Integer templateId = customRule.getTemplateId();
            Preconditions.checkNotNull((Object)templateId, (String)"Template id of the custom rule '%s' is null", (Object[])new Object[]{customRule});
            Optional template = this.dbClient.ruleDao().selectDefinitionById((long)templateId.intValue(), dbSession);
            if (template.isPresent() && ((RuleDefinitionDto)template.get()).getStatus() != RuleStatus.REMOVED) {
                if (!RegisterRules.updateCustomRuleFromTemplateRule(customRule, (RuleDefinitionDto)template.get())) continue;
                this.update(dbSession, customRule);
                continue;
            }
            this.removeRule(dbSession, recorder, customRule);
        }
        dbSession.commit();
    }

    private void removeRule(DbSession session, RegisterRulesContext recorder, RuleDefinitionDto rule) {
        LOG.info(String.format("Disable rule %s", rule.getKey()));
        rule.setStatus(RuleStatus.REMOVED);
        rule.setSystemTags(Collections.emptySet());
        this.update(session, rule);
        recorder.removed(rule);
        if (recorder.getRemoved().count() % 100L == 0L) {
            session.commit();
        }
    }

    private static boolean updateCustomRuleFromTemplateRule(RuleDefinitionDto customRule, RuleDefinitionDto templateRule) {
        boolean changed = false;
        if (!StringUtils.equals((String)customRule.getLanguage(), (String)templateRule.getLanguage())) {
            customRule.setLanguage(templateRule.getLanguage());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getConfigKey(), (String)templateRule.getConfigKey())) {
            customRule.setConfigKey(templateRule.getConfigKey());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getPluginKey(), (String)templateRule.getPluginKey())) {
            customRule.setPluginKey(templateRule.getPluginKey());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getDefRemediationFunction(), (String)templateRule.getDefRemediationFunction())) {
            customRule.setDefRemediationFunction(templateRule.getDefRemediationFunction());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getDefRemediationGapMultiplier(), (String)templateRule.getDefRemediationGapMultiplier())) {
            customRule.setDefRemediationGapMultiplier(templateRule.getDefRemediationGapMultiplier());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getDefRemediationBaseEffort(), (String)templateRule.getDefRemediationBaseEffort())) {
            customRule.setDefRemediationBaseEffort(templateRule.getDefRemediationBaseEffort());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getGapDescription(), (String)templateRule.getGapDescription())) {
            customRule.setGapDescription(templateRule.getGapDescription());
            changed = true;
        }
        if (customRule.getStatus() != templateRule.getStatus()) {
            customRule.setStatus(templateRule.getStatus());
            changed = true;
        }
        if (!StringUtils.equals((String)customRule.getSeverityString(), (String)templateRule.getSeverityString())) {
            customRule.setSeverity(templateRule.getSeverityString());
            changed = true;
        }
        return changed;
    }

    private List<ActiveRuleChange> removeActiveRulesOnStillExistingRepositories(DbSession dbSession, RegisterRulesContext recorder, List<RulesDefinition.ExtendedRepository> context) {
        List repositoryKeys = (List)context.stream().map(RulesDefinition.ExtendedRepository::key).collect(MoreCollectors.toList((int)context.size()));
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass()));
        recorder.getRemoved().forEach(rule -> {
            if (repositoryKeys.contains(rule.getRepositoryKey())) {
                profiler.start();
                changes.addAll(this.qProfileRules.deleteRule(dbSession, (RuleDefinitionDto)rule));
                profiler.stopDebug(String.format("Remove active rule for rule %s", rule.getKey()));
            }
        });
        return changes;
    }

    private void update(DbSession session, RuleDefinitionDto rule) {
        rule.setUpdatedAt(this.system2.now());
        this.dbClient.ruleDao().update(session, rule);
    }

    private static void verifyRuleKeyConsistency(List<RulesDefinition.ExtendedRepository> repositories, RegisterRulesContext registerRulesContext) {
        List definedRules = (List)repositories.stream().flatMap(r -> r.rules().stream()).collect(MoreCollectors.toList());
        Set definedRuleKeys = (Set)definedRules.stream().map(r -> RuleKey.of((String)r.repository().key(), (String)r.key())).collect(MoreCollectors.toSet());
        List definedDeprecatedRuleKeys = (List)definedRules.stream().flatMap(r -> r.deprecatedRuleKeys().stream()).collect(MoreCollectors.toList());
        Set duplicates = RegisterRules.findDuplicates(definedDeprecatedRuleKeys);
        Preconditions.checkState((boolean)duplicates.isEmpty(), (String)"The following deprecated rule keys are declared at least twice [%s]", (Object[])new Object[]{RegisterRules.lazyToString(() -> duplicates.stream().map(RuleKey::toString).collect(Collectors.joining(",")))});
        ImmutableSet intersection = Sets.intersection(new HashSet(definedRuleKeys), new HashSet(definedDeprecatedRuleKeys)).immutableCopy();
        Preconditions.checkState((boolean)intersection.isEmpty(), (String)"The following rule keys are declared both as deprecated and used key [%s]", (Object[])new Object[]{RegisterRules.lazyToString(() -> RegisterRules.lambda$verifyRuleKeyConsistency$10((Set)intersection))});
        ImmutableMap dbDeprecatedRuleKeysByOldRuleKey = registerRulesContext.getDbDeprecatedKeysByOldRuleKey();
        Set incorrectRuleKeyMessage = definedRules.stream().flatMap(r -> RegisterRules.filterInvalidDeprecatedRuleKeys((ImmutableMap<RuleKey, SingleDeprecatedRuleKey>)dbDeprecatedRuleKeysByOldRuleKey, r)).filter(Objects::nonNull).collect(Collectors.toSet());
        Preconditions.checkState((boolean)incorrectRuleKeyMessage.isEmpty(), (String)"An incorrect state of deprecated rule keys has been detected.\n %s", (Object[])new Object[]{RegisterRules.lazyToString(() -> incorrectRuleKeyMessage.stream().collect(Collectors.joining("\n")))});
    }

    private static Stream<String> filterInvalidDeprecatedRuleKeys(ImmutableMap<RuleKey, SingleDeprecatedRuleKey> dbDeprecatedRuleKeysByOldRuleKey, RulesDefinition.Rule rule) {
        return rule.deprecatedRuleKeys().stream().map(rk -> {
            SingleDeprecatedRuleKey singleDeprecatedRuleKey = (SingleDeprecatedRuleKey)dbDeprecatedRuleKeysByOldRuleKey.get(rk);
            if (singleDeprecatedRuleKey == null) {
                return null;
            }
            RuleKey parentRuleKey = RuleKey.of((String)rule.repository().key(), (String)rule.key());
            if (parentRuleKey.equals((Object)singleDeprecatedRuleKey.getNewRuleKeyAsRuleKey())) {
                return null;
            }
            if (rule.deprecatedRuleKeys().contains(parentRuleKey)) {
                return null;
            }
            return String.format("The deprecated rule key [%s] was previously deprecated by [%s]. [%s] should be a deprecated key of [%s],", rk.toString(), singleDeprecatedRuleKey.getNewRuleKeyAsRuleKey().toString(), singleDeprecatedRuleKey.getNewRuleKeyAsRuleKey().toString(), RuleKey.of((String)rule.repository().key(), (String)rule.key()).toString());
        });
    }

    private static Object lazyToString(final Supplier<String> toString) {
        return new Object(){

            public String toString() {
                return (String)toString.get();
            }
        };
    }

    private static <T> Set<T> findDuplicates(Collection<T> list) {
        HashSet duplicates = new HashSet();
        HashSet uniques = new HashSet();
        list.stream().forEach(t -> {
            if (!uniques.add(t)) {
                duplicates.add(t);
            }
        });
        return duplicates;
    }

    private static /* synthetic */ String lambda$verifyRuleKeyConsistency$10(Set intersection) {
        return intersection.stream().map(RuleKey::toString).collect(Collectors.joining(","));
    }

    private static class RegisterRulesContext {
        private final Map<RuleKey, RuleDefinitionDto> dbRules;
        private final Set<RuleDefinitionDto> known;
        private final Map<Integer, Set<SingleDeprecatedRuleKey>> dbDeprecatedKeysById;
        private final Map<RuleKey, RuleDefinitionDto> dbRulesByDbDeprecatedKey;
        private final Set<RuleDefinitionDto> created = new HashSet<RuleDefinitionDto>();
        private final Map<RuleDefinitionDto, RuleKey> renamed = new HashMap<RuleDefinitionDto, RuleKey>();
        private final Set<RuleDefinitionDto> updated = new HashSet<RuleDefinitionDto>();
        private final Set<RuleDefinitionDto> unchanged = new HashSet<RuleDefinitionDto>();
        private final Set<RuleDefinitionDto> removed = new HashSet<RuleDefinitionDto>();

        private RegisterRulesContext(Map<RuleKey, RuleDefinitionDto> dbRules, Map<Integer, Set<SingleDeprecatedRuleKey>> dbDeprecatedKeysById) {
            this.dbRules = ImmutableMap.copyOf(dbRules);
            this.known = ImmutableSet.copyOf(dbRules.values());
            this.dbDeprecatedKeysById = dbDeprecatedKeysById;
            this.dbRulesByDbDeprecatedKey = RegisterRulesContext.buildDbRulesByDbDeprecatedKey(dbDeprecatedKeysById, dbRules);
        }

        private static Map<RuleKey, RuleDefinitionDto> buildDbRulesByDbDeprecatedKey(Map<Integer, Set<SingleDeprecatedRuleKey>> dbDeprecatedKeysById, Map<RuleKey, RuleDefinitionDto> dbRules) {
            Map dbRulesByRuleId = (Map)dbRules.values().stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getId));
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Integer, Set<SingleDeprecatedRuleKey>> entry : dbDeprecatedKeysById.entrySet()) {
                Integer ruleId = entry.getKey();
                RuleDefinitionDto rule = (RuleDefinitionDto)dbRulesByRuleId.get(ruleId);
                if (rule == null) {
                    LOG.warn("Could not retrieve rule with id %s referenced by a deprecated rule key. The following deprecated rule keys seem to be referencing a non-existing rule", (Object)ruleId, entry.getValue());
                    continue;
                }
                entry.getValue().forEach(d -> builder.put((Object)d.getOldRuleKeyAsRuleKey(), (Object)rule));
            }
            return builder.build();
        }

        private Optional<RuleDefinitionDto> getDbRuleFor(RulesDefinition.Rule ruleDef) {
            RuleKey ruleKey = RuleKey.of((String)ruleDef.repository().key(), (String)ruleDef.key());
            Optional<RuleDefinitionDto> res = Stream.concat(Stream.of(ruleKey), ruleDef.deprecatedRuleKeys().stream()).map(this.dbRules::get).filter(Objects::nonNull).findFirst();
            if (!res.isPresent()) {
                return Optional.ofNullable(this.dbRulesByDbDeprecatedKey.get(ruleKey));
            }
            return res;
        }

        private ImmutableMap<RuleKey, SingleDeprecatedRuleKey> getDbDeprecatedKeysByOldRuleKey() {
            return (ImmutableMap)this.dbDeprecatedKeysById.values().stream().flatMap(Collection::stream).collect(MoreCollectors.uniqueIndex(SingleDeprecatedRuleKey::getOldRuleKeyAsRuleKey));
        }

        private Set<SingleDeprecatedRuleKey> getDBDeprecatedKeysFor(RuleDefinitionDto rule) {
            return this.dbDeprecatedKeysById.getOrDefault(rule.getId(), Collections.emptySet());
        }

        private Stream<RuleDefinitionDto> getRemaining() {
            HashSet<RuleDefinitionDto> res = new HashSet<RuleDefinitionDto>(this.dbRules.values());
            res.removeAll(this.unchanged);
            res.removeAll(this.renamed.keySet());
            res.removeAll(this.updated);
            res.removeAll(this.removed);
            return res.stream();
        }

        private Stream<RuleDefinitionDto> getRemoved() {
            return this.removed.stream();
        }

        public Stream<Map.Entry<RuleDefinitionDto, RuleKey>> getRenamed() {
            return this.renamed.entrySet().stream();
        }

        private Stream<RuleDefinitionDto> getAllModified() {
            return Stream.of(this.created.stream(), this.updated.stream(), this.removed.stream(), this.renamed.keySet().stream()).flatMap(s -> s);
        }

        private boolean isCreated(RuleDefinitionDto ruleDefinition) {
            return this.created.contains(ruleDefinition);
        }

        private boolean isRenamed(RuleDefinitionDto ruleDefinition) {
            return this.renamed.containsKey(ruleDefinition);
        }

        private boolean isUpdated(RuleDefinitionDto ruleDefinition) {
            return this.updated.contains(ruleDefinition);
        }

        private void created(RuleDefinitionDto ruleDefinition) {
            Preconditions.checkState((!this.known.contains(ruleDefinition) ? 1 : 0) != 0, (Object)"known RuleDefinitionDto can't be created");
            this.created.add(ruleDefinition);
        }

        private void renamed(RuleDefinitionDto ruleDefinition) {
            this.ensureKnown(ruleDefinition);
            this.renamed.put(ruleDefinition, ruleDefinition.getKey());
        }

        private void updated(RuleDefinitionDto ruleDefinition) {
            this.ensureKnown(ruleDefinition);
            this.updated.add(ruleDefinition);
        }

        private void removed(RuleDefinitionDto ruleDefinition) {
            this.ensureKnown(ruleDefinition);
            this.removed.add(ruleDefinition);
        }

        private void unchanged(RuleDefinitionDto ruleDefinition) {
            this.ensureKnown(ruleDefinition);
            this.unchanged.add(ruleDefinition);
        }

        private void ensureKnown(RuleDefinitionDto ruleDefinition) {
            Preconditions.checkState((boolean)this.known.contains(ruleDefinition), (Object)"unknown RuleDefinitionDto");
        }
    }
}

