/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.server.plugins.ServerPluginRepository;
import org.sonar.server.rule.CommonRuleDefinitions;
import org.sonar.server.rule.DeprecatedRulesDefinitionLoader;

public class RuleDefinitionsLoader {
    private final DeprecatedRulesDefinitionLoader deprecatedDefConverter;
    private final CommonRuleDefinitions coreCommonDefs;
    private final RulesDefinition[] pluginDefs;
    private final ServerPluginRepository serverPluginRepository;

    public RuleDefinitionsLoader(DeprecatedRulesDefinitionLoader deprecatedDefConverter, CommonRuleDefinitions coreCommonDefs, ServerPluginRepository serverPluginRepository, RulesDefinition[] pluginDefs) {
        this.deprecatedDefConverter = deprecatedDefConverter;
        this.coreCommonDefs = coreCommonDefs;
        this.serverPluginRepository = serverPluginRepository;
        this.pluginDefs = pluginDefs;
    }

    public RuleDefinitionsLoader(DeprecatedRulesDefinitionLoader converter, CommonRuleDefinitions coreCommonDefs, ServerPluginRepository serverPluginRepository) {
        this(converter, coreCommonDefs, serverPluginRepository, new RulesDefinition[0]);
    }

    public RulesDefinition.Context load() {
        RulesDefinition.Context context = new RulesDefinition.Context();
        for (RulesDefinition pluginDefinition : this.pluginDefs) {
            context.setCurrentPluginKey(this.serverPluginRepository.getPluginKey(pluginDefinition));
            pluginDefinition.define(context);
        }
        this.deprecatedDefConverter.complete(context);
        context.setCurrentPluginKey(null);
        this.coreCommonDefs.define(context);
        return context;
    }
}

