/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.OrgActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;
import org.sonar.server.rule.index.RuleQuery;
import org.sonarqube.ws.Rules;

@ServerSide
public class ActiveRuleCompleter {
    private final DbClient dbClient;
    private final Languages languages;

    public ActiveRuleCompleter(DbClient dbClient, Languages languages) {
        this.dbClient = dbClient;
        this.languages = languages;
    }

    void completeSearch(DbSession dbSession, RuleQuery query, List<RuleDto> rules, Rules.SearchResponse.Builder searchResponse) {
        Set<String> profileUuids = this.writeActiveRules(dbSession, searchResponse, query, rules);
        searchResponse.setQProfiles(this.buildQProfiles(dbSession, profileUuids));
    }

    private Set<String> writeActiveRules(DbSession dbSession, Rules.SearchResponse.Builder response, RuleQuery query, List<RuleDto> rules) {
        HashSet<String> profileUuids = new HashSet<String>();
        Rules.Actives.Builder activesBuilder = response.getActivesBuilder();
        QProfileDto profile = query.getQProfile();
        if (profile != null) {
            List activeRules = this.dbClient.activeRuleDao().selectByProfile(dbSession, profile);
            Map activeRuleByRuleKey = (Map)activeRules.stream().collect(MoreCollectors.uniqueIndex(ActiveRuleDto::getRuleKey));
            ListMultimap<ActiveRuleKey, ActiveRuleParamDto> activeRuleParamsByActiveRuleKey = this.loadParams(dbSession, activeRules);
            for (RuleDto rule2 : rules) {
                OrgActiveRuleDto activeRule = (OrgActiveRuleDto)activeRuleByRuleKey.get(rule2.getKey());
                if (activeRule == null) continue;
                profileUuids.addAll(ActiveRuleCompleter.writeActiveRules(rule2.getKey(), Collections.singletonList(activeRule), activeRuleParamsByActiveRuleKey, activesBuilder));
            }
        } else {
            List ruleIds = Lists.transform(rules, RuleDto::getId);
            List activeRules = this.dbClient.activeRuleDao().selectByRuleIds(dbSession, query.getOrganization(), ruleIds);
            Multimap activeRulesByRuleKey = (Multimap)activeRules.stream().collect(MoreCollectors.index(ActiveRuleDto::getRuleKey));
            ListMultimap<ActiveRuleKey, ActiveRuleParamDto> activeRuleParamsByActiveRuleKey = this.loadParams(dbSession, activeRules);
            rules.forEach(rule -> profileUuids.addAll(ActiveRuleCompleter.writeActiveRules(rule.getKey(), activeRulesByRuleKey.get((Object)rule.getKey()), activeRuleParamsByActiveRuleKey, activesBuilder)));
        }
        response.setActives(activesBuilder);
        return profileUuids;
    }

    private static Set<String> writeActiveRules(RuleKey ruleKey, Collection<OrgActiveRuleDto> activeRules, ListMultimap<ActiveRuleKey, ActiveRuleParamDto> activeRuleParamsByActiveRuleKey, Rules.Actives.Builder activesBuilder) {
        HashSet<String> profileUuids = new HashSet<String>();
        Rules.ActiveList.Builder activeRulesListResponse = Rules.ActiveList.newBuilder();
        for (OrgActiveRuleDto activeRule : activeRules) {
            activeRulesListResponse.addActiveList(ActiveRuleCompleter.buildActiveRuleResponse(activeRule, activeRuleParamsByActiveRuleKey.get((Object)activeRule.getKey())));
            profileUuids.add(activeRule.getProfileUuid());
        }
        activesBuilder.getMutableActives().put(ruleKey.toString(), activeRulesListResponse.build());
        return profileUuids;
    }

    private ListMultimap<ActiveRuleKey, ActiveRuleParamDto> loadParams(DbSession dbSession, List<OrgActiveRuleDto> activeRules) {
        HashMap<Integer, ActiveRuleKey> activeRuleIdsByKey = new HashMap<Integer, ActiveRuleKey>();
        for (OrgActiveRuleDto activeRule : activeRules) {
            activeRuleIdsByKey.put(activeRule.getId(), activeRule.getKey());
        }
        List activeRuleParams = this.dbClient.activeRuleDao().selectParamsByActiveRuleIds(dbSession, Lists.transform(activeRules, ActiveRuleDto::getId));
        ArrayListMultimap activeRuleParamsByActiveRuleKey = ArrayListMultimap.create((int)activeRules.size(), (int)10);
        for (ActiveRuleParamDto activeRuleParam : activeRuleParams) {
            ActiveRuleKey activeRuleKey = (ActiveRuleKey)activeRuleIdsByKey.get(activeRuleParam.getActiveRuleId());
            activeRuleParamsByActiveRuleKey.put((Object)activeRuleKey, (Object)activeRuleParam);
        }
        return activeRuleParamsByActiveRuleKey;
    }

    List<Rules.Active> completeShow(DbSession dbSession, OrganizationDto organization, RuleDefinitionDto rule) {
        List activeRules = this.dbClient.activeRuleDao().selectByRuleId(dbSession, organization, rule.getId().intValue());
        HashMap<Integer, ActiveRuleKey> activeRuleIdsByKey = new HashMap<Integer, ActiveRuleKey>();
        for (OrgActiveRuleDto activeRuleDto : activeRules) {
            activeRuleIdsByKey.put(activeRuleDto.getId(), activeRuleDto.getKey());
        }
        List activeRuleIds = activeRules.stream().map(ActiveRuleDto::getId).collect(Collectors.toList());
        List activeRuleParams = this.dbClient.activeRuleDao().selectParamsByActiveRuleIds(dbSession, activeRuleIds);
        ArrayListMultimap activeRuleParamsByActiveRuleKey = ArrayListMultimap.create((int)activeRules.size(), (int)10);
        for (ActiveRuleParamDto activeRuleParamDto : activeRuleParams) {
            ActiveRuleKey activeRuleKey = (ActiveRuleKey)activeRuleIdsByKey.get(activeRuleParamDto.getActiveRuleId());
            activeRuleParamsByActiveRuleKey.put((Object)activeRuleKey, (Object)activeRuleParamDto);
        }
        return activeRules.stream().map(arg_0 -> ActiveRuleCompleter.lambda$completeShow$1((ListMultimap)activeRuleParamsByActiveRuleKey, arg_0)).collect(Collectors.toList());
    }

    private static Rules.Active buildActiveRuleResponse(OrgActiveRuleDto activeRule, List<ActiveRuleParamDto> parameters) {
        Rules.Active.Builder builder = Rules.Active.newBuilder();
        builder.setQProfile(activeRule.getProfileUuid());
        String inheritance = activeRule.getInheritance();
        builder.setInherit(inheritance != null ? inheritance : ActiveRuleInheritance.NONE.name());
        builder.setSeverity(activeRule.getSeverityString());
        builder.setCreatedAt(DateUtils.formatDateTime((long)activeRule.getCreatedAt()));
        builder.setUpdatedAt(DateUtils.formatDateTime((long)activeRule.getUpdatedAt()));
        Rules.Active.Param.Builder paramBuilder = Rules.Active.Param.newBuilder();
        for (ActiveRuleParamDto parameter : parameters) {
            builder.addParams(paramBuilder.clear().setKey(parameter.getKey()).setValue(Strings.nullToEmpty((String)parameter.getValue())));
        }
        return builder.build();
    }

    private Rules.QProfiles.Builder buildQProfiles(DbSession dbSession, Set<String> profileUuids) {
        Rules.QProfiles.Builder result = Rules.QProfiles.newBuilder();
        if (profileUuids.isEmpty()) {
            return result;
        }
        Map profilesByUuid = this.dbClient.qualityProfileDao().selectByUuids(dbSession, new ArrayList<String>(profileUuids)).stream().collect(Collectors.toMap(QProfileDto::getKee, Function.identity()));
        List parentUuids = (List)profilesByUuid.values().stream().map(QProfileDto::getParentKee).filter(StringUtils::isNotEmpty).filter(uuid -> !profilesByUuid.containsKey(uuid)).collect(MoreCollectors.toList());
        if (!parentUuids.isEmpty()) {
            this.dbClient.qualityProfileDao().selectByUuids(dbSession, parentUuids).forEach(p -> profilesByUuid.put(p.getKee(), p));
        }
        Map qProfilesMapResponse = result.getMutableQProfiles();
        profilesByUuid.values().forEach(p -> this.writeProfile(qProfilesMapResponse, (QProfileDto)p));
        return result;
    }

    private void writeProfile(Map<String, Rules.QProfile> profilesResponse, QProfileDto profile) {
        Rules.QProfile.Builder profileResponse = Rules.QProfile.newBuilder();
        Optional.ofNullable(profile.getName()).ifPresent(arg_0 -> ((Rules.QProfile.Builder)profileResponse).setName(arg_0));
        if (profile.getLanguage() != null) {
            profileResponse.setLang(profile.getLanguage());
            Language language = this.languages.get(profile.getLanguage());
            String langName = language == null ? profile.getLanguage() : language.getName();
            profileResponse.setLangName(langName);
        }
        Optional.ofNullable(profile.getParentKee()).ifPresent(arg_0 -> ((Rules.QProfile.Builder)profileResponse).setParent(arg_0));
        profilesResponse.put(profile.getKee(), profileResponse.build());
    }

    private static /* synthetic */ Rules.Active lambda$completeShow$1(ListMultimap activeRuleParamsByActiveRuleKey, OrgActiveRuleDto activeRule) {
        return ActiveRuleCompleter.buildActiveRuleResponse(activeRule, activeRuleParamsByActiveRuleKey.get((Object)activeRule.getKey()));
    }
}

