/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.securityreport.ws;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.qualityprofile.OrgActiveRuleDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.index.SecurityStandardCategoryStatistics;
import org.sonar.server.issue.index.SecurityStandardHelper;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;
import org.sonar.server.securityreport.ws.SecurityReportsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.SecurityReports;

public class ShowAction
implements SecurityReportsWsAction {
    private static final String PARAM_PROJECT = "project";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_INCLUDE_DISTRIBUTION = "includeDistribution";
    private static final String PARAM_STANDARD = "standard";
    private static final String OWASP_CAT_PREFIX = "a";
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final IssueIndex issueIndex;
    private final DbClient dbClient;

    public ShowAction(UserSession userSession, ComponentFinder componentFinder, IssueIndex issueIndex, DbClient dbClient) {
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.issueIndex = issueIndex;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setResponseExample(this.getClass().getResource("show-example.json")).setHandler((RequestHandler)this).setDescription("Return data used by security reports").setSince("7.3").setInternal(true);
        action.createParam(PARAM_PROJECT).setDescription("Project, view or application key").setRequired(true);
        action.createParam(PARAM_BRANCH).setDescription("Branch name").setExampleValue((Object)"branch-2.0");
        action.createParam(PARAM_STANDARD).setDescription("Security standard").setPossibleValues((Object[])new String[]{"owaspTop10", "sansTop25"}).setRequired(true);
        action.createParam(PARAM_INCLUDE_DISTRIBUTION).setDescription("To return CWE distribution").setBooleanPossibleValues().setDefaultValue((Object)"false");
    }

    public final void handle(Request request, Response response) {
        boolean isViewOrApp;
        String qualifier;
        ComponentDto projectDto;
        String projectKey = request.mandatoryParam(PARAM_PROJECT);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            projectDto = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, projectKey, request.param(PARAM_BRANCH), null);
        }
        this.userSession.checkComponentPermission("user", projectDto);
        switch (qualifier = projectDto.qualifier()) {
            case "VW": 
            case "SVW": 
            case "APP": {
                isViewOrApp = true;
                break;
            }
            case "TRK": {
                isViewOrApp = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported component type " + qualifier);
            }
        }
        String standard = request.mandatoryParam(PARAM_STANDARD);
        boolean includeCwe = request.mandatoryParamAsBoolean(PARAM_INCLUDE_DISTRIBUTION);
        switch (standard) {
            case "owaspTop10": {
                List<SecurityStandardCategoryStatistics> owaspCategories = this.issueIndex.getOwaspTop10Report(projectDto.uuid(), isViewOrApp, includeCwe).stream().sorted(Comparator.comparing(ShowAction::index)).collect(Collectors.toList());
                this.completeStatistics(owaspCategories, projectDto, standard, includeCwe);
                ShowAction.writeResponse(request, response, owaspCategories);
                break;
            }
            case "sansTop25": {
                List<SecurityStandardCategoryStatistics> sansTop25Report = this.issueIndex.getSansTop25Report(projectDto.uuid(), isViewOrApp, includeCwe);
                this.completeStatistics(sansTop25Report, projectDto, standard, includeCwe);
                ShowAction.writeResponse(request, response, sansTop25Report);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported standard: '" + standard + "'");
            }
        }
    }

    private void completeStatistics(List<SecurityStandardCategoryStatistics> input, ComponentDto project, String standard, boolean includeCwe) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set qualityProfiles = this.dbClient.liveMeasureDao().selectMeasure(dbSession, project.projectUuid(), "quality_profiles").map(LiveMeasureDto::getDataAsString).map(data -> QPMeasureData.fromJson((String)data).getProfiles()).orElse(Collections.emptySortedSet());
            List activeRuleDtos = this.dbClient.activeRuleDao().selectByTypeAndProfileUuids(dbSession, Arrays.asList(RuleType.SECURITY_HOTSPOT.getDbConstant(), RuleType.VULNERABILITY.getDbConstant()), qualityProfiles.stream().map(QualityProfile::getQpKey).collect(Collectors.toList()));
            ArrayListMultimap activeRulesByCategory = ArrayListMultimap.create();
            activeRuleDtos.forEach(arg_0 -> ShowAction.lambda$completeStatistics$4(includeCwe, (Multimap)activeRulesByCategory, standard, arg_0));
            List ruleDtos = this.dbClient.ruleDao().selectByTypeAndLanguages(dbSession, project.getOrganizationUuid(), Arrays.asList(RuleType.SECURITY_HOTSPOT.getDbConstant(), RuleType.VULNERABILITY.getDbConstant()), qualityProfiles.stream().map(QualityProfile::getLanguageKey).collect(Collectors.toList()));
            ArrayListMultimap rulesByCategory = ArrayListMultimap.create();
            ruleDtos.forEach(arg_0 -> ShowAction.lambda$completeStatistics$8(includeCwe, (Multimap)rulesByCategory, standard, arg_0));
            input.forEach(arg_0 -> ShowAction.lambda$completeStatistics$10((Multimap)rulesByCategory, (Multimap)activeRulesByCategory, arg_0));
        }
    }

    private static Integer index(SecurityStandardCategoryStatistics owaspCat) {
        if (owaspCat.getCategory().startsWith(OWASP_CAT_PREFIX)) {
            return Integer.parseInt(owaspCat.getCategory().substring(OWASP_CAT_PREFIX.length()));
        }
        return 11;
    }

    private static void writeResponse(Request request, Response response, List<SecurityStandardCategoryStatistics> categories) {
        SecurityReports.ShowWsResponse.Builder builder = SecurityReports.ShowWsResponse.newBuilder();
        categories.forEach(cat -> {
            SecurityReports.SecurityStandardCategoryStatistics.Builder catBuilder = SecurityReports.SecurityStandardCategoryStatistics.newBuilder();
            catBuilder.setCategory(cat.getCategory()).setVulnerabilities(cat.getVulnerabilities());
            cat.getVulnerabiliyRating().ifPresent(arg_0 -> ((SecurityReports.SecurityStandardCategoryStatistics.Builder)catBuilder).setVulnerabilityRating(arg_0));
            catBuilder.setOpenSecurityHotspots(cat.getOpenSecurityHotspots()).setToReviewSecurityHotspots(cat.getToReviewSecurityHotspots()).setWontFixSecurityHotspots(cat.getWontFixSecurityHotspots()).setTotalRules(cat.getTotalRules()).setActiveRules(cat.getActiveRules());
            if (cat.getChildren() != null) {
                cat.getChildren().stream().sorted(Comparator.comparing(ShowAction.cweIndex())).forEach(cwe -> {
                    SecurityReports.CweStatistics.Builder cweBuilder = SecurityReports.CweStatistics.newBuilder();
                    cweBuilder.setCwe(cwe.getCategory()).setVulnerabilities(cwe.getVulnerabilities());
                    cwe.getVulnerabiliyRating().ifPresent(arg_0 -> ((SecurityReports.CweStatistics.Builder)cweBuilder).setVulnerabilityRating(arg_0));
                    cweBuilder.setOpenSecurityHotspots(cwe.getOpenSecurityHotspots()).setToReviewSecurityHotspots(cwe.getToReviewSecurityHotspots()).setWontFixSecurityHotspots(cwe.getWontFixSecurityHotspots()).setActiveRules(cwe.getActiveRules()).setTotalRules(cwe.getTotalRules());
                    catBuilder.addDistribution(cweBuilder);
                });
            }
            builder.addCategories(catBuilder);
        });
        WsUtils.writeProtobuf((Message)builder.build(), request, response);
    }

    private static Function<SecurityStandardCategoryStatistics, Integer> cweIndex() {
        return securityStandardCategoryStatistics -> {
            String category = securityStandardCategoryStatistics.getCategory();
            return category.equals("unknown") ? Integer.MAX_VALUE : Integer.parseInt(category);
        };
    }

    private static /* synthetic */ void lambda$completeStatistics$10(Multimap rulesByCategory, Multimap activeRulesByCategory, SecurityStandardCategoryStatistics c) {
        c.setTotalRules((long)rulesByCategory.get((Object)c.getCategory()).size());
        c.setActiveRules((long)activeRulesByCategory.get((Object)c.getCategory()).size());
        c.getChildren().forEach(child -> {
            child.setTotalRules((long)rulesByCategory.get((Object)child.getCategory()).size());
            child.setActiveRules((long)activeRulesByCategory.get((Object)child.getCategory()).size());
        });
    }

    private static /* synthetic */ void lambda$completeStatistics$8(boolean includeCwe, Multimap rulesByCategory, String standard, RuleDto r) {
        List cwe = SecurityStandardHelper.getCwe((Collection)r.getSecurityStandards());
        if (includeCwe) {
            cwe.forEach(s -> rulesByCategory.put(s, (Object)r));
        }
        switch (standard) {
            case "owaspTop10": {
                SecurityStandardHelper.getOwaspTop10((Collection)r.getSecurityStandards()).forEach(s -> rulesByCategory.put(s, (Object)r));
                break;
            }
            case "sansTop25": {
                SecurityStandardHelper.getSansTop25((Collection)cwe).forEach(s -> rulesByCategory.put(s, (Object)r));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported standard: '" + standard + "'");
            }
        }
    }

    private static /* synthetic */ void lambda$completeStatistics$4(boolean includeCwe, Multimap activeRulesByCategory, String standard, OrgActiveRuleDto r) {
        List cwe = SecurityStandardHelper.getCwe((String)r.getSecurityStandards());
        if (includeCwe) {
            cwe.forEach(s -> activeRulesByCategory.put(s, (Object)r));
        }
        switch (standard) {
            case "owaspTop10": {
                SecurityStandardHelper.getOwaspTop10((String)r.getSecurityStandards()).forEach(s -> activeRulesByCategory.put(s, (Object)r));
                break;
            }
            case "sansTop25": {
                SecurityStandardHelper.getSansTop25((Collection)cwe).forEach(s -> activeRulesByCategory.put(s, (Object)r));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported standard: '" + standard + "'");
            }
        }
    }
}

