/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.process.ProcessProperties;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.setting.ws.SettingsWs;
import org.sonar.server.user.UserSession;

@ServerSide
public class SettingsWsSupport {
    private static final Collector<CharSequence, ?, String> COMMA_JOINER = Collectors.joining(",");
    public static final String DOT_SECURED = ".secured";
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final UserSession userSession;

    public SettingsWsSupport(DefaultOrganizationProvider defaultOrganizationProvider, UserSession userSession) {
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.userSession = userSession;
    }

    static void validateKey(String key) {
        Arrays.stream(ProcessProperties.Property.values()).filter(property -> property.getKey().equalsIgnoreCase(key)).findFirst().ifPresent(property -> {
            throw new IllegalArgumentException(String.format("Setting '%s' can only be used in sonar.properties", key));
        });
    }

    boolean isVisible(String key, Optional<ComponentDto> component) {
        return this.hasPermission(OrganizationPermission.SCAN, "scan", component) || this.verifySecuredSetting(key, component);
    }

    static boolean isSecured(String key) {
        return key.endsWith(DOT_SECURED);
    }

    private boolean verifySecuredSetting(String key, Optional<ComponentDto> component) {
        return !SettingsWsSupport.isSecured(key) || this.hasPermission(OrganizationPermission.ADMINISTER, "admin", component);
    }

    private boolean hasPermission(OrganizationPermission orgPermission, String projectPermission, Optional<ComponentDto> component) {
        if (this.userSession.isSystemAdministrator()) {
            return true;
        }
        if (this.userSession.hasPermission(orgPermission, this.defaultOrganizationProvider.get().getUuid())) {
            return true;
        }
        return component.map(c -> this.userSession.hasPermission(orgPermission, c.getOrganizationUuid()) || this.userSession.hasComponentPermission(projectPermission, (ComponentDto)c)).orElse(false);
    }

    WebService.NewParam addBranchParam(WebService.NewAction action) {
        return action.createParam("branch").setDescription("Branch key. Only available on following settings : %s", new Object[]{SettingsWs.SETTING_ON_BRANCHES.stream().collect(COMMA_JOINER)}).setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
    }

    WebService.NewParam addPullRequestParam(WebService.NewAction action) {
        return action.createParam("pullRequest").setDescription("Pull request. Only available on following settings : %s", new Object[]{SettingsWs.SETTING_ON_BRANCHES.stream().collect(COMMA_JOINER)}).setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
    }
}

