/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.PropertyType;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.property.PropertyDto;
import org.sonar.process.ProcessProperties;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.setting.ws.PropertySetExtractor;
import org.sonar.server.setting.ws.Setting;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.setting.ws.SettingsWsSupport;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Settings;

public class ValuesAction
implements SettingsWsAction {
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final String COMMA_ENCODED_VALUE = "%2C";
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".").omitEmptyStrings();
    private static final Set<String> SERVER_SETTING_KEYS = ImmutableSet.of((Object)"sonar.core.startTime", (Object)"sonar.core.id");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final PropertyDefinitions propertyDefinitions;
    private final SettingsWsSupport settingsWsSupport;
    private final boolean isSonarCloud;

    public ValuesAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, PropertyDefinitions propertyDefinitions, SettingsWsSupport settingsWsSupport, Configuration configuration) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.propertyDefinitions = propertyDefinitions;
        this.settingsWsSupport = settingsWsSupport;
        this.isSonarCloud = configuration.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("values").setDescription("List settings values.<br>If no value has been set for a setting, then the default value is returned.<br>The settings from conf/sonar.properties are excluded from results.<br>Requires 'Browse' or 'Execute Analysis' permission when a component is specified.<br/>To access secured settings, one of the following permissions is required: <ul><li>'Execute Analysis'</li><li>'Administer System'</li><li>'Administer' rights on the specified component</li></ul>").setResponseExample(this.getClass().getResource("values-example.json")).setSince("6.3").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component")), new Change("7.1", "The settings from conf/sonar.properties are excluded from results.")}).setHandler((RequestHandler)this);
        action.createParam("keys").setDescription("List of setting keys").setExampleValue((Object)"sonar.test.inclusions,sonar.exclusions");
        action.createParam("component").setDescription("Component key").setExampleValue((Object)"my_project");
        this.settingsWsSupport.addBranchParam(action);
        this.settingsWsSupport.addPullRequestParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        WsUtils.writeProtobuf((Message)this.doHandle(request), request, response);
    }

    private Settings.ValuesWsResponse doHandle(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            ValuesRequest valuesRequest = ValuesRequest.from(request);
            Optional<ComponentDto> component = this.loadComponent(dbSession, valuesRequest);
            Set<String> keys = this.loadKeys(valuesRequest);
            Map<String, String> keysToDisplayMap = this.getKeysToDisplayMap(keys);
            List<Setting> settings = this.loadSettings(dbSession, component, keysToDisplayMap.keySet());
            Settings.ValuesWsResponse valuesWsResponse = new ValuesResponseBuilder(settings, component, keysToDisplayMap).build();
            return valuesWsResponse;
        }
    }

    private Set<String> loadKeys(ValuesRequest valuesRequest) {
        List<String> keys = valuesRequest.getKeys();
        Object result = keys == null || keys.isEmpty() ? Stream.concat(this.propertyDefinitions.getAll().stream().map(PropertyDefinition::key), SERVER_SETTING_KEYS.stream()).collect(Collectors.toSet()) : ImmutableSet.copyOf(keys);
        result.forEach(SettingsWsSupport::validateKey);
        return result;
    }

    private Optional<ComponentDto> loadComponent(DbSession dbSession, ValuesRequest valuesRequest) {
        String componentKey = valuesRequest.getComponent();
        if (componentKey == null) {
            return Optional.empty();
        }
        ComponentDto component = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, valuesRequest.getBranch(), valuesRequest.getPullRequest());
        if (!(this.userSession.hasComponentPermission("user", component) || this.userSession.hasComponentPermission("scan", component) || this.userSession.hasPermission(OrganizationPermission.SCAN, component.getOrganizationUuid()))) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        return Optional.of(component);
    }

    private List<Setting> loadSettings(DbSession dbSession, Optional<ComponentDto> component, Set<String> keys) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        settings.addAll(this.loadDefaultValues(keys));
        settings.addAll(this.loadGlobalSettings(dbSession, keys));
        if (component.isPresent() && component.get().getBranch() != null && component.get().getMainBranchProjectUuid() != null) {
            ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(dbSession, component.get().getMainBranchProjectUuid());
            settings.addAll(this.loadComponentSettings(dbSession, keys, project).values());
        }
        component.ifPresent(componentDto -> settings.addAll(this.loadComponentSettings(dbSession, keys, (ComponentDto)componentDto).values()));
        return settings.stream().filter(s -> this.settingsWsSupport.isVisible(s.getKey(), component)).collect(Collectors.toList());
    }

    private List<Setting> loadDefaultValues(Set<String> keys) {
        return this.propertyDefinitions.getAll().stream().filter(definition -> keys.contains(definition.key())).filter(defaultProperty -> !StringUtils.isEmpty((String)defaultProperty.defaultValue())).map(Setting::createFromDefinition).collect(Collectors.toList());
    }

    private Map<String, String> getKeysToDisplayMap(Set<String> keys) {
        return keys.stream().collect(Collectors.toMap(arg_0 -> ((PropertyDefinitions)this.propertyDefinitions).validKey(arg_0), Function.identity(), (u, v) -> {
            throw new IllegalArgumentException(String.format("'%s' and '%s' cannot be used at the same time as they refer to the same setting", u, v));
        }));
    }

    private List<Setting> loadGlobalSettings(DbSession dbSession, Set<String> keys) {
        Set<String> allowedKeys = this.isSonarCloud && !this.userSession.isSystemAdministrator() ? keys.stream().filter(k -> !SettingsWsSupport.isSecured(k)).collect(Collectors.toSet()) : keys;
        List properties = this.dbClient.propertiesDao().selectGlobalPropertiesByKeys(dbSession, allowedKeys);
        List propertySets = this.dbClient.propertiesDao().selectGlobalPropertiesByKeys(dbSession, this.getPropertySetKeys(properties));
        return (List)properties.stream().map(property -> Setting.createFromDto(property, ValuesAction.getPropertySets(property.getKey(), propertySets, null), this.propertyDefinitions.get(property.getKey()))).collect(MoreCollectors.toList((int)properties.size()));
    }

    private Multimap<String, Setting> loadComponentSettings(DbSession dbSession, Set<String> keys, ComponentDto component) {
        List componentUuids = DOT_SPLITTER.splitToList((CharSequence)component.moduleUuidPath());
        List componentDtos = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids);
        Set componentIds = componentDtos.stream().map(ComponentDto::getId).collect(Collectors.toSet());
        Map<Long, String> uuidsById = componentDtos.stream().collect(Collectors.toMap(ComponentDto::getId, ComponentDto::uuid));
        List properties = this.dbClient.propertiesDao().selectPropertiesByKeysAndComponentIds(dbSession, keys, componentIds);
        List propertySets = this.dbClient.propertiesDao().selectPropertiesByKeysAndComponentIds(dbSession, this.getPropertySetKeys(properties), componentIds);
        TreeMultimap settingsByUuid = TreeMultimap.create((Comparator)Ordering.explicit((List)componentUuids), (Comparator)Ordering.arbitrary());
        for (PropertyDto propertyDto : properties) {
            Long componentId = propertyDto.getResourceId();
            String componentUuid = uuidsById.get(componentId);
            String propertyKey = propertyDto.getKey();
            settingsByUuid.put((Object)componentUuid, (Object)Setting.createFromDto(propertyDto, ValuesAction.getPropertySets(propertyKey, propertySets, componentId), this.propertyDefinitions.get(propertyKey)));
        }
        return settingsByUuid;
    }

    private Set<String> getPropertySetKeys(List<PropertyDto> properties) {
        return properties.stream().filter(propertyDto -> this.propertyDefinitions.get(propertyDto.getKey()) != null).filter(propertyDto -> this.propertyDefinitions.get(propertyDto.getKey()).type().equals((Object)PropertyType.PROPERTY_SET)).flatMap(propertyDto -> PropertySetExtractor.extractPropertySetKeys(propertyDto, this.propertyDefinitions.get(propertyDto.getKey())).stream()).collect(Collectors.toSet());
    }

    private static List<PropertyDto> getPropertySets(String propertyKey, List<PropertyDto> propertySets, @Nullable Long componentId) {
        return propertySets.stream().filter(propertyDto -> Objects.equals(propertyDto.getResourceId(), componentId)).filter(propertyDto -> propertyDto.getKey().startsWith(propertyKey + ".")).collect(Collectors.toList());
    }

    private static class ValuesRequest {
        private String branch;
        private String pullRequest;
        private String component;
        private List<String> keys;

        private ValuesRequest() {
        }

        public ValuesRequest setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        @CheckForNull
        public String getBranch() {
            return this.branch;
        }

        public ValuesRequest setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        @CheckForNull
        public String getPullRequest() {
            return this.pullRequest;
        }

        public ValuesRequest setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        @CheckForNull
        public String getComponent() {
            return this.component;
        }

        public ValuesRequest setKeys(@Nullable List<String> keys) {
            this.keys = keys;
            return this;
        }

        @CheckForNull
        public List<String> getKeys() {
            return this.keys;
        }

        private static ValuesRequest from(Request request) {
            ValuesRequest result = new ValuesRequest().setComponent(request.param("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest"));
            if (request.hasParam("keys")) {
                result.setKeys(request.paramAsStrings("keys"));
            }
            return result;
        }
    }

    private class ValuesResponseBuilder {
        private final List<Setting> settings;
        private final Optional<ComponentDto> requestedComponent;
        private final Settings.ValuesWsResponse.Builder valuesWsBuilder = Settings.ValuesWsResponse.newBuilder();
        private final Map<String, Settings.Setting.Builder> settingsBuilderByKey = new HashMap<String, Settings.Setting.Builder>();
        private final Map<String, Setting> settingsByParentKey = new HashMap<String, Setting>();
        private final Map<String, String> keysToDisplayMap;

        ValuesResponseBuilder(List<Setting> settings, Optional<ComponentDto> requestedComponent, Map<String, String> keysToDisplayMap) {
            this.settings = settings;
            this.requestedComponent = requestedComponent;
            this.keysToDisplayMap = keysToDisplayMap;
        }

        Settings.ValuesWsResponse build() {
            this.processSettings();
            this.settingsBuilderByKey.values().forEach(Settings.Setting.Builder::build);
            return this.valuesWsBuilder.build();
        }

        private void processSettings() {
            this.settings.forEach(setting -> {
                Settings.Setting.Builder valueBuilder = this.getOrCreateValueBuilder(this.keysToDisplayMap.get(setting.getKey()));
                this.setInherited((Setting)setting, valueBuilder);
                this.setValue((Setting)setting, valueBuilder);
                this.setParent((Setting)setting, valueBuilder);
            });
        }

        private Settings.Setting.Builder getOrCreateValueBuilder(String key) {
            return this.settingsBuilderByKey.computeIfAbsent(key, k -> this.valuesWsBuilder.addSettingsBuilder().setKey(key));
        }

        private void setInherited(Setting setting, Settings.Setting.Builder valueBuilder) {
            boolean isDefault = setting.isDefault();
            boolean isGlobal = !this.requestedComponent.isPresent();
            boolean isOnComponent = this.requestedComponent.isPresent() && Objects.equals(setting.getComponentId(), this.requestedComponent.get().getId());
            boolean isSet = isGlobal || isOnComponent;
            valueBuilder.setInherited(isDefault || !isSet);
        }

        private void setValue(Setting setting, Settings.Setting.Builder valueBuilder) {
            PropertyDefinition definition = setting.getDefinition();
            String value = setting.getValue();
            if (definition == null) {
                valueBuilder.setValue(value);
                return;
            }
            if (definition.type().equals((Object)PropertyType.PROPERTY_SET)) {
                valueBuilder.setFieldValues(this.createFieldValuesBuilder(this.filterVisiblePropertySets(setting.getPropertySets())));
            } else if (definition.multiValues()) {
                valueBuilder.setValues(this.createValuesBuilder(value));
            } else {
                valueBuilder.setValue(value);
            }
        }

        private void setParent(Setting setting, Settings.Setting.Builder valueBuilder) {
            Setting parent = this.settingsByParentKey.get(setting.getKey());
            if (parent != null) {
                String value = valueBuilder.getInherited() ? setting.getValue() : parent.getValue();
                PropertyDefinition definition = setting.getDefinition();
                if (definition == null) {
                    valueBuilder.setParentValue(value);
                    return;
                }
                if (definition.type().equals((Object)PropertyType.PROPERTY_SET)) {
                    valueBuilder.setParentFieldValues(this.createFieldValuesBuilder(valueBuilder.getInherited() ? this.filterVisiblePropertySets(setting.getPropertySets()) : this.filterVisiblePropertySets(parent.getPropertySets())));
                } else if (definition.multiValues()) {
                    valueBuilder.setParentValues(this.createValuesBuilder(value));
                } else {
                    valueBuilder.setParentValue(value);
                }
            }
            this.settingsByParentKey.put(setting.getKey(), setting);
        }

        private Settings.Values.Builder createValuesBuilder(String value) {
            List values = COMMA_SPLITTER.splitToList((CharSequence)value).stream().map(v -> v.replace(ValuesAction.COMMA_ENCODED_VALUE, ",")).collect(Collectors.toList());
            return Settings.Values.newBuilder().addAllValues(values);
        }

        private Settings.FieldValues.Builder createFieldValuesBuilder(List<Map<String, String>> fieldValues) {
            Settings.FieldValues.Builder builder = Settings.FieldValues.newBuilder();
            for (Map<String, String> propertySetMap : fieldValues) {
                builder.addFieldValuesBuilder().putAllValue(propertySetMap);
            }
            return builder;
        }

        private List<Map<String, String>> filterVisiblePropertySets(List<Map<String, String>> propertySets) {
            ArrayList<Map<String, String>> filteredPropertySets = new ArrayList<Map<String, String>>();
            propertySets.forEach(map -> {
                HashMap set = new HashMap();
                map.entrySet().stream().filter(entry -> ValuesAction.this.settingsWsSupport.isVisible((String)entry.getKey(), this.requestedComponent)).forEach(entry -> {
                    String cfr_ignored_0 = (String)set.put(entry.getKey(), entry.getValue());
                });
                filteredPropertySets.add(set);
            });
            return filteredPropertySets;
        }
    }
}

