/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.core.platform.EditionProvider;
import org.sonar.server.measure.index.ProjectMeasuresStatistics;

public class TelemetryData {
    private final String serverId;
    private final String version;
    private final Map<String, String> plugins;
    private final long ncloc;
    private final long userCount;
    private final long projectCount;
    private final boolean usingBranches;
    private final Database database;
    private final Map<String, Long> projectCountByLanguage;
    private final Map<String, Long> nclocByLanguage;
    private final Optional<EditionProvider.Edition> edition;
    private final String licenseType;

    private TelemetryData(Builder builder) {
        this.serverId = builder.serverId;
        this.version = builder.version;
        this.plugins = builder.plugins;
        this.ncloc = builder.ncloc;
        this.userCount = builder.userCount;
        this.projectCount = builder.projectMeasuresStatistics.getProjectCount();
        this.usingBranches = builder.usingBranches;
        this.database = builder.database;
        this.projectCountByLanguage = builder.projectMeasuresStatistics.getProjectCountByLanguage();
        this.nclocByLanguage = builder.projectMeasuresStatistics.getNclocByLanguage();
        this.edition = builder.edition;
        this.licenseType = builder.licenseType;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    public long getNcloc() {
        return this.ncloc;
    }

    public long getUserCount() {
        return this.userCount;
    }

    public long getProjectCount() {
        return this.projectCount;
    }

    public boolean isUsingBranches() {
        return this.usingBranches;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Map<String, Long> getProjectCountByLanguage() {
        return this.projectCountByLanguage;
    }

    public Map<String, Long> getNclocByLanguage() {
        return this.nclocByLanguage;
    }

    public Optional<EditionProvider.Edition> getEdition() {
        return this.edition;
    }

    public Optional<String> getLicenseType() {
        return Optional.ofNullable(this.licenseType);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Database {
        private final String name;
        private final String version;

        Database(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }

    static class Builder {
        private String serverId;
        private String version;
        private long userCount;
        private Map<String, String> plugins;
        private Database database;
        private ProjectMeasuresStatistics projectMeasuresStatistics;
        private Long ncloc;
        private Boolean usingBranches;
        private Optional<EditionProvider.Edition> edition;
        private String licenseType;

        private Builder() {
        }

        Builder setServerId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        Builder setUserCount(long userCount) {
            this.userCount = userCount;
            return this;
        }

        Builder setPlugins(Map<String, String> plugins) {
            this.plugins = plugins;
            return this;
        }

        Builder setProjectMeasuresStatistics(ProjectMeasuresStatistics projectMeasuresStatistics) {
            this.projectMeasuresStatistics = projectMeasuresStatistics;
            return this;
        }

        Builder setNcloc(long ncloc) {
            this.ncloc = ncloc;
            return this;
        }

        Builder setDatabase(Database database) {
            this.database = database;
            return this;
        }

        Builder setUsingBranches(boolean usingBranches) {
            this.usingBranches = usingBranches;
            return this;
        }

        public Builder setEdition(Optional<EditionProvider.Edition> edition) {
            this.edition = edition;
            return this;
        }

        public Builder setLicenseType(@Nullable String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        TelemetryData build() {
            Objects.requireNonNull(this.serverId);
            Objects.requireNonNull(this.version);
            Objects.requireNonNull(this.plugins);
            Objects.requireNonNull(this.projectMeasuresStatistics);
            Objects.requireNonNull(this.ncloc);
            Objects.requireNonNull(this.database);
            Objects.requireNonNull(this.usingBranches);
            Objects.requireNonNull(this.edition);
            return new TelemetryData(this);
        }
    }
}

