/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import java.util.Locale;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.telemetry.TelemetryData;

public class TelemetryDataJsonWriter {
    private TelemetryDataJsonWriter() {
    }

    public static void writeTelemetryData(JsonWriter json, TelemetryData statistics) {
        json.beginObject();
        json.prop("id", statistics.getServerId());
        json.prop("version", statistics.getVersion());
        statistics.getEdition().ifPresent(e -> json.prop("edition", e.name().toLowerCase(Locale.ENGLISH)));
        statistics.getLicenseType().ifPresent(e -> json.prop("licenseType", e));
        json.name("database");
        json.beginObject();
        json.prop("name", statistics.getDatabase().getName());
        json.prop("version", statistics.getDatabase().getVersion());
        json.endObject();
        json.name("plugins");
        json.beginArray();
        statistics.getPlugins().forEach((plugin, version) -> {
            json.beginObject();
            json.prop("name", plugin);
            json.prop("version", version);
            json.endObject();
        });
        json.endArray();
        json.prop("userCount", statistics.getUserCount());
        json.prop("projectCount", statistics.getProjectCount());
        json.prop("usingBranches", statistics.isUsingBranches());
        json.prop("ncloc", statistics.getNcloc());
        json.name("projectCountByLanguage");
        json.beginArray();
        statistics.getProjectCountByLanguage().forEach((language, count) -> {
            json.beginObject();
            json.prop("language", language);
            json.prop("count", (Number)count);
            json.endObject();
        });
        json.endArray();
        json.name("nclocByLanguage");
        json.beginArray();
        statistics.getNclocByLanguage().forEach((language, ncloc) -> {
            json.beginObject();
            json.prop("language", language);
            json.prop("ncloc", (Number)ncloc);
            json.endObject();
        });
        json.endArray();
        json.endObject();
    }
}

