/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui.ws;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.web.page.Page;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.property.PropertyQuery;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;
import org.sonar.server.project.Visibility;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;
import org.sonar.server.ui.PageRepository;
import org.sonar.server.ui.ws.NavigationWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class ComponentAction
implements NavigationWsAction {
    static final String PARAM_COMPONENT = "component";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_PULL_REQUEST = "pullRequest";
    private static final String PROPERTY_CONFIGURABLE = "configurable";
    private static final String PROPERTY_HAS_ROLE_POLICY = "hasRolePolicy";
    private static final String PROPERTY_MODIFIABLE_HISTORY = "modifiable_history";
    private static final String PROPERTY_UPDATABLE_KEY = "updatable_key";
    private static final Set<String> QUALIFIERS_WITH_VISIBILITY = ImmutableSet.of((Object)"TRK", (Object)"VW", (Object)"APP");
    private final DbClient dbClient;
    private final PageRepository pageRepository;
    private final ResourceTypes resourceTypes;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final QualityGateFinder qualityGateFinder;
    private final BillingValidationsProxy billingValidations;

    public ComponentAction(DbClient dbClient, PageRepository pageRepository, ResourceTypes resourceTypes, UserSession userSession, ComponentFinder componentFinder, QualityGateFinder qualityGateFinder, BillingValidationsProxy billingValidations) {
        this.dbClient = dbClient;
        this.pageRepository = pageRepository;
        this.resourceTypes = resourceTypes;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.qualityGateFinder = qualityGateFinder;
        this.billingValidations = billingValidations;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(PARAM_COMPONENT).setDescription("Get information concerning component navigation for the current user. Requires the 'Browse' permission on the component's project.").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("component-example.json")).setSince("5.2").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", PARAM_COMPONENT)), new Change("7.3", "The 'almRepoUrl' and 'almId' fields are added"), new Change("6.4", "The 'visibility' field is added")});
        action.createParam(PARAM_COMPONENT).setDescription("A component key.").setDeprecatedKey("componentKey", "6.4").setExampleValue((Object)"my_project");
        action.createParam(PARAM_BRANCH).setDescription("Branch key").setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_PULL_REQUEST).setDescription("Pull request id").setExampleValue((Object)"5461");
    }

    public void handle(Request request, Response response) throws Exception {
        String componentKey = request.mandatoryParam(PARAM_COMPONENT);
        try (DbSession session = this.dbClient.openSession(false);){
            ComponentDto rootProject;
            String branch = request.param(PARAM_BRANCH);
            String pullRequest = request.param(PARAM_PULL_REQUEST);
            ComponentDto component = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(session, componentKey, branch, pullRequest);
            WsUtils.checkComponentNotAModuleAndNotADirectory(component);
            ComponentDto rootProjectOrBranch = this.getRootProjectOrBranch(component, session);
            ComponentDto componentDto = rootProject = rootProjectOrBranch.getMainBranchProjectUuid() == null ? rootProjectOrBranch : this.componentFinder.getByUuid(session, rootProjectOrBranch.getMainBranchProjectUuid());
            if (!(this.userSession.hasComponentPermission("user", component) || this.userSession.hasComponentPermission("admin", component) || this.userSession.isSystemAdministrator())) {
                throw AbstractUserSession.insufficientPrivilegesException();
            }
            OrganizationDto org = this.componentFinder.getOrganization(session, component);
            Optional analysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(session, component.projectUuid());
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            this.writeComponent(json, session, component, org, analysis.orElse(null));
            this.writeAlmDetails(json, session, rootProject);
            this.writeProfiles(json, session, component);
            this.writeQualityGate(json, session, org, rootProject);
            if (this.userSession.hasComponentPermission("admin", component) || this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, org) || this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, org)) {
                this.writeConfiguration(json, component, org);
            }
            this.writeBreadCrumbs(json, session, component);
            json.endObject().close();
        }
    }

    private ComponentDto getRootProjectOrBranch(ComponentDto component, DbSession session) {
        if (!component.isRootProject()) {
            return this.dbClient.componentDao().selectOrFailByUuid(session, component.projectUuid());
        }
        return component;
    }

    private void writeAlmDetails(JsonWriter json, DbSession session, ComponentDto component) {
        Optional bindingOpt = this.dbClient.projectAlmBindingsDao().selectByProjectUuid(session, component.uuid());
        bindingOpt.ifPresent(b -> {
            String almId = String.valueOf(b.getAlm().getId());
            json.name("alm").beginObject().prop("key", almId).prop("url", b.getUrl()).endObject();
        });
    }

    private static void writeToJson(JsonWriter json, QualityProfile profile, boolean deleted) {
        json.beginObject().prop("key", profile.getQpKey()).prop("name", profile.getQpName()).prop("language", profile.getLanguageKey()).prop("deleted", deleted).endObject();
    }

    private static void writePage(JsonWriter json, Page page) {
        json.beginObject().prop("key", page.getKey()).prop("name", page.getName()).endObject();
    }

    private void writeComponent(JsonWriter json, DbSession session, ComponentDto component, OrganizationDto organizationDto, @Nullable SnapshotDto analysis) {
        json.prop("key", component.getKey()).prop("organization", organizationDto.getKey()).prop("id", component.uuid()).prop("name", component.name()).prop("description", component.description()).prop("isFavorite", this.isFavourite(session, component));
        String branch = component.getBranch();
        if (branch != null) {
            json.prop(PARAM_BRANCH, branch);
        }
        if (QUALIFIERS_WITH_VISIBILITY.contains(component.qualifier())) {
            json.prop("visibility", Visibility.getLabel(component.isPrivate()));
        }
        List<Page> pages = this.pageRepository.getComponentPages(false, component.qualifier());
        this.writeExtensions(json, component, pages);
        if (analysis != null) {
            json.prop("version", analysis.getProjectVersion()).prop("analysisDate", DateUtils.formatDateTime((Date)new Date(analysis.getCreatedAt())));
        }
    }

    private boolean isFavourite(DbSession session, ComponentDto component) {
        PropertyQuery propertyQuery = PropertyQuery.builder().setUserId(this.userSession.getUserId()).setKey("favourite").setComponentId(component.getId()).build();
        List componentFavourites = this.dbClient.propertiesDao().selectByQuery(propertyQuery, session);
        return componentFavourites.size() == 1;
    }

    private void writeProfiles(JsonWriter json, DbSession dbSession, ComponentDto component) {
        Set qualityProfiles = this.dbClient.liveMeasureDao().selectMeasure(dbSession, component.projectUuid(), "quality_profiles").map(LiveMeasureDto::getDataAsString).map(data -> QPMeasureData.fromJson((String)data).getProfiles()).orElse(Collections.emptySortedSet());
        Map dtoByQPKey = (Map)this.dbClient.qualityProfileDao().selectByUuids(dbSession, qualityProfiles.stream().map(QualityProfile::getQpKey).collect(Collectors.toList())).stream().collect(MoreCollectors.uniqueIndex(QProfileDto::getKee));
        json.name("qualityProfiles").beginArray();
        qualityProfiles.forEach(qp -> ComponentAction.writeToJson(json, qp, !dtoByQPKey.containsKey(qp.getQpKey())));
        json.endArray();
    }

    private void writeQualityGate(JsonWriter json, DbSession session, OrganizationDto organization, ComponentDto component) {
        QualityGateFinder.QualityGateData qualityGateData = (QualityGateFinder.QualityGateData)this.qualityGateFinder.getQualityGate(session, organization, component).orElseThrow(() -> new NotFoundException(String.format("Quality Gate not found for %s", component.getKey())));
        QualityGateDto qualityGateDto = qualityGateData.getQualityGate();
        json.name("qualityGate").beginObject().prop("key", (Number)qualityGateDto.getId()).prop("name", qualityGateDto.getName()).prop("isDefault", qualityGateData.isDefault()).endObject();
    }

    private void writeExtensions(JsonWriter json, ComponentDto component, List<Page> pages) {
        json.name("extensions").beginArray();
        Predicate<Page> isAuthorized = page -> {
            String requiredPermission = page.isAdmin() ? "admin" : "user";
            return this.userSession.hasComponentPermission(requiredPermission, component);
        };
        pages.stream().filter(isAuthorized).forEach(page -> ComponentAction.writePage(json, page));
        json.endArray();
    }

    private void writeConfiguration(JsonWriter json, ComponentDto component, OrganizationDto organization) {
        boolean isProjectAdmin = this.userSession.hasComponentPermission("admin", component);
        json.name("configuration").beginObject();
        this.writeConfigPageAccess(json, isProjectAdmin, component, organization);
        if (isProjectAdmin) {
            json.name("extensions").beginArray();
            List<Page> configPages = this.pageRepository.getComponentPages(true, component.qualifier());
            configPages.forEach(page -> ComponentAction.writePage(json, page));
            json.endArray();
        }
        json.endObject();
    }

    private void writeConfigPageAccess(JsonWriter json, boolean isProjectAdmin, ComponentDto component, OrganizationDto organization) {
        boolean isProject = "TRK".equals(component.qualifier());
        boolean showManualMeasures = isProjectAdmin && !"DIR".equals(component.qualifier());
        boolean showBackgroundTasks = isProjectAdmin && (isProject || "VW".equals(component.qualifier()) || "APP".equals(component.qualifier()));
        boolean isQualityProfileAdmin = this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, component.getOrganizationUuid());
        boolean isQualityGateAdmin = this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, component.getOrganizationUuid());
        boolean isOrganizationAdmin = this.userSession.hasPermission(OrganizationPermission.ADMINISTER, component.getOrganizationUuid());
        json.prop("showSettings", isProjectAdmin && this.componentTypeHasProperty(component, PROPERTY_CONFIGURABLE));
        json.prop("showQualityProfiles", isProject && (isProjectAdmin || isQualityProfileAdmin));
        json.prop("showQualityGates", isProject && (isProjectAdmin || isQualityGateAdmin));
        json.prop("showManualMeasures", showManualMeasures);
        json.prop("showLinks", isProjectAdmin && isProject);
        json.prop("showPermissions", isProjectAdmin && this.componentTypeHasProperty(component, PROPERTY_HAS_ROLE_POLICY));
        json.prop("showHistory", isProjectAdmin && this.componentTypeHasProperty(component, PROPERTY_MODIFIABLE_HISTORY));
        json.prop("showUpdateKey", isProjectAdmin && this.componentTypeHasProperty(component, PROPERTY_UPDATABLE_KEY));
        json.prop("showBackgroundTasks", showBackgroundTasks);
        json.prop("canApplyPermissionTemplate", isOrganizationAdmin);
        json.prop("canUpdateProjectVisibilityToPrivate", isProjectAdmin && this.billingValidations.canUpdateProjectVisibilityToPrivate(new BillingValidations.Organization(organization.getKey(), organization.getUuid(), organization.getName())));
    }

    private boolean componentTypeHasProperty(ComponentDto component, String resourceTypeProperty) {
        ResourceType resourceType = this.resourceTypes.get(component.qualifier());
        return resourceType != null && resourceType.getBooleanProperty(resourceTypeProperty);
    }

    private void writeBreadCrumbs(JsonWriter json, DbSession session, ComponentDto component) {
        json.name("breadcrumbs").beginArray();
        ArrayList breadcrumb = Lists.newArrayList();
        breadcrumb.addAll(this.dbClient.componentDao().selectAncestors(session, component));
        breadcrumb.add(component);
        for (ComponentDto c : breadcrumb) {
            json.beginObject().prop("key", c.getKey()).prop("name", c.name()).prop("qualifier", c.qualifier()).endObject();
        }
        json.endArray();
    }
}

