/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.process.ProcessProperties;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.user.ws.HomepageTypes;

public class HomepageTypesImpl
implements HomepageTypes,
Startable {
    private static final EnumSet<HomepageTypes.Type> ON_SONARQUBE = EnumSet.of(HomepageTypes.Type.PROJECTS, HomepageTypes.Type.PROJECT, HomepageTypes.Type.ISSUES, HomepageTypes.Type.ORGANIZATION);
    private static final EnumSet<HomepageTypes.Type> ON_SONARCLOUD = EnumSet.of(HomepageTypes.Type.PROJECT, HomepageTypes.Type.MY_PROJECTS, HomepageTypes.Type.MY_ISSUES, HomepageTypes.Type.ORGANIZATION);
    private final Configuration configuration;
    private final OrganizationFlags organizationFlags;
    private final DbClient dbClient;
    private List<HomepageTypes.Type> types;

    public HomepageTypesImpl(Configuration configuration, OrganizationFlags organizationFlags, DbClient dbClient) {
        this.configuration = configuration;
        this.organizationFlags = organizationFlags;
        this.dbClient = dbClient;
    }

    @Override
    public List<HomepageTypes.Type> getTypes() {
        Preconditions.checkState((this.types != null ? 1 : 0) != 0, (Object)"Homepage types have not been initialized yet");
        return this.types;
    }

    @Override
    public HomepageTypes.Type getDefaultType() {
        return this.isOnSonarCloud() != false ? HomepageTypes.Type.MY_PROJECTS : HomepageTypes.Type.PROJECTS;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            boolean isOnSonarCloud = this.isOnSonarCloud();
            boolean isOrganizationEnabled = this.isOrganizationEnabled(dbSession);
            this.types = Arrays.stream(HomepageTypes.Type.values()).filter(type -> isOnSonarCloud && ON_SONARCLOUD.contains(type) || !isOnSonarCloud && ON_SONARQUBE.contains(type)).filter(type -> isOrganizationEnabled || !type.equals((Object)HomepageTypes.Type.ORGANIZATION)).collect(Collectors.toList());
        }
    }

    private boolean isOrganizationEnabled(DbSession dbSession) {
        return this.organizationFlags.isEnabled(dbSession);
    }

    private Boolean isOnSonarCloud() {
        return this.configuration.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
    }

    public void stop() {
    }
}

