/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.usergroups.ws.UserGroupsWsAction;
import org.sonar.server.ws.WsUtils;

public class AddUserAction
implements UserGroupsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final GroupWsSupport support;

    public AddUserAction(DbClient dbClient, UserSession userSession, GroupWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_user").setDescription(String.format("Add a user to a group.<br />'%s' or '%s' must be provided.<br />Requires the following permission: 'Administer System'.", "id", "name")).setHandler((RequestHandler)this).setPost(true).setSince("5.2").setChangelog(new Change[]{new Change("6.4", "It's no longer possible to add a user to the default group")});
        GroupWsSupport.defineGroupWsParameters(action);
        GroupWsSupport.defineLoginWsParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            GroupDto group = this.support.findGroupDto(dbSession, request);
            this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER, group.getOrganizationUuid());
            String login = request.mandatoryParam("login");
            UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
            WsUtils.checkFound(user, "Could not find a user with login '%s'", login);
            OrganizationDto organization = this.support.findOrganizationByKey(dbSession, request.param("organization"));
            this.checkMembership(dbSession, organization, user);
            this.support.checkGroupIsNotDefault(dbSession, group);
            if (!this.isMemberOf(dbSession, user, group)) {
                UserGroupDto membershipDto = new UserGroupDto().setGroupId(group.getId().intValue()).setUserId(user.getId().intValue());
                this.dbClient.userGroupDao().insert(dbSession, membershipDto);
                dbSession.commit();
            }
            response.noContent();
        }
    }

    private boolean isMemberOf(DbSession dbSession, UserDto user, GroupDto groupId) {
        return this.dbClient.groupMembershipDao().selectGroupIdsByUserId(dbSession, user.getId().intValue()).contains(groupId.getId());
    }

    private void checkMembership(DbSession dbSession, OrganizationDto organization, UserDto user) {
        Preconditions.checkArgument((boolean)this.dbClient.organizationMemberDao().select(dbSession, organization.getUuid(), user.getId().intValue()).isPresent(), (String)"User '%s' is not member of organization '%s'", (Object[])new Object[]{user.getLogin(), organization.getKey()});
    }
}

