/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken;

import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.authentication.UserLastConnectionDatesUpdater;
import org.sonar.server.usertoken.TokenGenerator;

public class UserTokenAuthentication {
    private final TokenGenerator tokenGenerator;
    private final DbClient dbClient;
    private final UserLastConnectionDatesUpdater userLastConnectionDatesUpdater;

    public UserTokenAuthentication(TokenGenerator tokenGenerator, DbClient dbClient, UserLastConnectionDatesUpdater userLastConnectionDatesUpdater) {
        this.tokenGenerator = tokenGenerator;
        this.dbClient = dbClient;
        this.userLastConnectionDatesUpdater = userLastConnectionDatesUpdater;
    }

    public Optional<String> authenticate(String token) {
        String tokenHash = this.tokenGenerator.hash(token);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserTokenDto userToken = this.dbClient.userTokenDao().selectByTokenHash(dbSession, tokenHash);
            if (userToken == null) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            this.userLastConnectionDatesUpdater.updateLastConnectionDateIfNeeded(userToken);
            Optional<String> optional = Optional.of(userToken.getUserUuid());
            return optional;
        }
    }
}

