/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.PropertyType;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.util.TypeValidation;

public class FloatTypeValidation
implements TypeValidation {
    @Override
    public String key() {
        return PropertyType.FLOAT.name();
    }

    @Override
    public void validate(String value, @Nullable List<String> options) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw BadRequestException.create(String.format("Value '%s' must be an floating point number.", value));
        }
    }
}

