/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

public class MetricKeyValidator {
    private static final String VALID_METRIC_KEY_REGEXP = "[\\p{Alnum}\\-_]*[\\p{Alpha}\\-_]+[\\p{Alnum}\\-_]*";

    private MetricKeyValidator() {
    }

    public static boolean isMetricKeyValid(String candidateKey) {
        return candidateKey.matches(VALID_METRIC_KEY_REGEXP);
    }

    public static String checkMetricKeyFormat(String candidateKey) {
        if (!MetricKeyValidator.isMetricKeyValid(candidateKey)) {
            throw new IllegalArgumentException(String.format("Malformed metric key '%s'. Allowed characters are alphanumeric, '-', '_', with at least one non-digit.", candidateKey));
        }
        return candidateKey;
    }
}

