/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import okhttp3.HttpUrl;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UserSession;

public class WebhookSupport {
    private final UserSession userSession;

    public WebhookSupport(UserSession userSession) {
        this.userSession = userSession;
    }

    void checkPermission(ComponentDto componentDto) {
        this.userSession.checkComponentPermission("admin", componentDto);
    }

    void checkPermission(OrganizationDto organizationDto) {
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organizationDto);
    }

    void checkUrlPattern(String url, String message, Object ... messageArguments) {
        if (HttpUrl.parse((String)url) == null) {
            throw new IllegalArgumentException(String.format(message, messageArguments));
        }
    }

    void checkThatProjectBelongsToOrganization(ComponentDto componentDto, OrganizationDto organizationDto, String message, Object ... messageArguments) {
        if (!organizationDto.getUuid().equals(componentDto.getOrganizationUuid())) {
            throw new NotFoundException(String.format(message, messageArguments));
        }
    }
}

