/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.in;

import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.staxmate.in.SMElementInfo;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputContext;
import org.codehaus.staxmate.in.SMInputCursor;

abstract class CursorBase {
    private static final SMEvent[] EVENTS_BY_IDS = SMEvent.constructIdToEventMapping();
    protected final SMInputContext _context;
    protected final XMLStreamReader2 _streamReader;
    protected final int _baseDepth;
    protected State _state = State.INITIAL;
    protected SMEvent _currEvent = null;
    protected int _nodeCount = 0;
    protected int _elemCount = 0;
    protected SMElementInfo _trackedElement = null;
    protected SMElementInfo _parentTrackedElement = null;
    protected SMInputCursor _childCursor = null;

    protected CursorBase(SMInputContext ctxt, int baseDepth) {
        this._context = ctxt;
        this._streamReader = ctxt.getStreamReader();
        this._baseDepth = baseDepth;
    }

    protected abstract String getCurrEventDesc();

    public abstract boolean isRootCursor();

    public abstract XMLStreamException constructStreamException(String var1);

    public abstract void throwStreamException(String var1) throws XMLStreamException;

    protected final int getBaseParentCount() {
        return this._baseDepth;
    }

    protected final void rewindPastChild() throws XMLStreamException {
        SMInputCursor child = this._childCursor;
        this._childCursor = null;
        child.invalidate();
        int endDepth = child.getBaseParentCount();
        XMLStreamReader2 sr = this._streamReader;
        int type = sr.getEventType();
        while (true) {
            if (type == 2) {
                int depth = sr.getDepth();
                if (depth <= endDepth) {
                    if (depth == endDepth) break;
                    this._throwWrongEndElem(endDepth, depth);
                    break;
                }
            } else if (type == 8) {
                this._throwUnexpectedEndDoc();
            }
            type = sr.next();
        }
    }

    protected void invalidate() throws XMLStreamException {
        this._state = State.CLOSED;
        this._currEvent = null;
        if (this._childCursor != null) {
            this._childCursor.invalidate();
            this._childCursor = null;
        }
    }

    protected final XMLStreamReader2 _getStreamReader() {
        return this._streamReader;
    }

    protected static final SMEvent eventObjectByEventId(int type) {
        return EVENTS_BY_IDS[type];
    }

    protected XMLStreamException _notAccessible(String method) throws XMLStreamException {
        if (this._childCursor != null) {
            return this.constructStreamException("Can not call '" + method + "(): cursor does not point to a valid node, as it has an active open child cursor.");
        }
        return this.constructStreamException("Can not call '" + method + "(): cursor does not point to a valid node (curr event " + this.getCurrEventDesc() + "; cursor state " + this.getStateDesc() + ")");
    }

    protected XMLStreamException _wrongState(String method, SMEvent expState) throws XMLStreamException {
        return this.constructStreamException("Can not call '" + method + "()' when cursor is not positioned over " + (Object)((Object)expState) + " but " + this.currentEventStr());
    }

    protected String getStateDesc() {
        return this._state.toString();
    }

    protected String currentEventStr() {
        return this._currEvent == null ? "null" : this._currEvent.toString();
    }

    void _throwUnexpectedEndDoc() throws XMLStreamException {
        throw new IllegalStateException("Unexpected END_DOCUMENT encountered (root = " + this.isRootCursor() + "; reader impl " + this._getStreamReader().getClass().getName() + "); location: " + this._streamReader.getLocation());
    }

    void _throwWrongEndElem(int expDepth, int actDepth) throws IllegalStateException {
        throw new IllegalStateException("Expected to encounter END_ELEMENT with depth >= " + expDepth + ", got " + actDepth);
    }

    TypedXMLStreamException _constructTypedException(String value, IllegalArgumentException rootCause, String msg) {
        return new TypedXMLStreamException(value, msg, this._getStreamReader().getLocation(), rootCause);
    }

    public String toString() {
        return "{" + this.getClass().getName() + ": " + (Object)((Object)this._state) + ", curr evt: " + (Object)((Object)this._currEvent) + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIAL,
        ACTIVE,
        HAS_CHILD,
        CLOSED;

    }
}

