/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.core.extension.PlatformLevel;

public final class PlatformLevelPredicates {
    private PlatformLevelPredicates() {
    }

    public static Predicate<Object> hasPlatformLevel(int i) {
        PlatformLevelPredicates.checkSupportedLevel(i, null);
        return o -> {
            PlatformLevel platformLevel = AnnotationUtils.getAnnotation(o, PlatformLevel.class);
            return platformLevel != null && PlatformLevelPredicates.checkSupportedLevel(platformLevel.value(), o) == i;
        };
    }

    private static int checkSupportedLevel(int i, @Nullable Object annotatedObject) {
        boolean supported;
        boolean bl = supported = i >= 1 && i <= 4;
        if (supported) {
            return i;
        }
        throw new IllegalArgumentException(PlatformLevelPredicates.buildErrorMsgFrom(annotatedObject));
    }

    private static String buildErrorMsgFrom(@Nullable Object annotatedObject) {
        String baseErrorMsg = "Only level 1, 2, 3 and 4 are supported";
        if (annotatedObject == null) {
            return baseErrorMsg;
        }
        if (annotatedObject instanceof Class) {
            return String.format("Invalid value for annotation %s on class '%s'. %s", PlatformLevel.class.getName(), ((Class)annotatedObject).getName(), baseErrorMsg);
        }
        return String.format("Invalid value for annotation %s on object of type %s. %s", PlatformLevel.class.getName(), annotatedObject.getClass().getName(), baseErrorMsg);
    }

    public static Predicate<Object> hasPlatformLevel4OrNone() {
        return o -> {
            PlatformLevel platformLevel = AnnotationUtils.getAnnotation(o, PlatformLevel.class);
            return platformLevel == null || PlatformLevelPredicates.checkSupportedLevel(platformLevel.value(), o) == 4;
        };
    }
}

