/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.time.Clock;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.Plugin;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.internal.ApiVersion;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.extension.CoreExtensionRepositoryImpl;
import org.sonar.core.extension.CoreExtensionsLoader;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.PluginClassloaderFactory;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginLoader;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.DefaultHttpDownloader;
import org.sonar.core.util.UuidFactoryImpl;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.GlobalConfigurationProvider;
import org.sonar.scanner.bootstrap.GlobalServerSettingsProvider;
import org.sonar.scanner.bootstrap.GlobalTempFolderProvider;
import org.sonar.scanner.bootstrap.PluginFiles;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.RawScannerProperties;
import org.sonar.scanner.bootstrap.ScannerPluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPluginJarExploder;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.bootstrap.ScannerWsClientProvider;
import org.sonar.scanner.extension.ScannerCoreExtensionsInstaller;
import org.sonar.scanner.platform.DefaultServer;
import org.sonar.scanner.repository.DefaultMetricsRepositoryLoader;
import org.sonar.scanner.repository.MetricsRepositoryLoader;
import org.sonar.scanner.repository.MetricsRepositoryProvider;
import org.sonar.scanner.repository.settings.DefaultGlobalSettingsLoader;
import org.sonar.scanner.repository.settings.GlobalSettingsLoader;
import org.sonar.scanner.scan.ProjectScanContainer;

public class GlobalContainer
extends ComponentContainer {
    private static final Logger LOG = Loggers.get(GlobalContainer.class);
    private final Map<String, String> scannerProperties;

    private GlobalContainer(Map<String, String> scannerProperties) {
        this.scannerProperties = scannerProperties;
    }

    public static GlobalContainer create(Map<String, String> scannerProperties, List<?> extensions) {
        GlobalContainer container = new GlobalContainer(scannerProperties);
        container.add(extensions);
        return container;
    }

    @Override
    protected void doBeforeStart() {
        RawScannerProperties rawScannerProperties = new RawScannerProperties(this.scannerProperties);
        GlobalAnalysisMode globalMode = new GlobalAnalysisMode(rawScannerProperties);
        this.add(rawScannerProperties);
        this.add(globalMode);
        this.addBootstrapComponents();
    }

    private void addBootstrapComponents() {
        Version apiVersion = ApiVersion.load(System2.INSTANCE);
        this.add(ScannerPluginRepository.class, PluginLoader.class, PluginClassloaderFactory.class, ScannerPluginJarExploder.class, ExtensionInstaller.class, new SonarQubeVersion(apiVersion), SonarRuntimeImpl.forSonarQube(apiVersion, SonarQubeSide.SCANNER), new GlobalServerSettingsProvider(), new GlobalConfigurationProvider(), new ScannerWsClientProvider(), DefaultServer.class, new GlobalTempFolderProvider(), DefaultHttpDownloader.class, UriReader.class, PluginFiles.class, System2.INSTANCE, Clock.systemDefaultZone(), new MetricsRepositoryProvider(), UuidFactoryImpl.INSTANCE);
        this.addIfMissing(ScannerPluginInstaller.class, PluginInstaller.class);
        this.add(CoreExtensionRepositoryImpl.class, CoreExtensionsLoader.class, ScannerCoreExtensionsInstaller.class);
        this.addIfMissing(DefaultGlobalSettingsLoader.class, GlobalSettingsLoader.class);
        this.addIfMissing(DefaultMetricsRepositoryLoader.class, MetricsRepositoryLoader.class);
    }

    @Override
    protected void doAfterStart() {
        this.installPlugins();
        this.loadCoreExtensions();
        long startTime = System.currentTimeMillis();
        String taskKey = StringUtils.defaultIfEmpty(this.scannerProperties.get("sonar.task"), "scan");
        if (taskKey.equals("views")) {
            throw MessageException.of("The task 'views' was removed with SonarQube 7.1. You can safely remove this call since portfolios and applications are automatically re-calculated.");
        }
        if (!taskKey.equals("scan")) {
            throw MessageException.of("Tasks support was removed in SonarQube 7.6.");
        }
        String analysisMode = StringUtils.defaultIfEmpty(this.scannerProperties.get("sonar.analysis.mode"), "publish");
        if (!analysisMode.equals("publish")) {
            throw MessageException.of("The preview mode, along with the 'sonar.analysis.mode' parameter, is no more supported. You should stop using this parameter.");
        }
        new ProjectScanContainer(this).execute();
        LOG.info("Analysis total time: {}", (Object)GlobalContainer.formatTime(System.currentTimeMillis() - startTime));
    }

    private void installPlugins() {
        PluginRepository pluginRepository = this.getComponentByType(PluginRepository.class);
        for (PluginInfo pluginInfo : pluginRepository.getPluginInfos()) {
            Plugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, (Object)instance);
        }
    }

    private void loadCoreExtensions() {
        CoreExtensionsLoader loader = this.getComponentByType(CoreExtensionsLoader.class);
        loader.load();
    }

    static String formatTime(long time) {
        long h = time / 3600000L;
        long m = (time - h * 60L * 60L * 1000L) / 60000L;
        long s = (time - h * 60L * 60L * 1000L - m * 60L * 1000L) / 1000L;
        long ms = time % 1000L;
        String format = h > 0L ? "%1$d:%2$02d:%3$02d.%4$03d s" : (m > 0L ? "%2$d:%3$02d.%4$03d s" : "%3$d.%4$03d s");
        return String.format(format, h, m, s, ms);
    }
}

