/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.bootstrap.RawScannerProperties;

public class GlobalTempFolderProvider
extends ProviderAdapter
implements ComponentLifecycle<TempFolder> {
    private static final Logger LOG = Loggers.get(GlobalTempFolderProvider.class);
    private static final long CLEAN_MAX_AGE = TimeUnit.DAYS.toMillis(21L);
    static final String TMP_NAME_PREFIX = ".sonartmp_";
    private boolean started = false;
    private System2 system;
    private DefaultTempFolder tempFolder;

    public GlobalTempFolderProvider() {
        this(new System2());
    }

    GlobalTempFolderProvider(System2 system) {
        this.system = system;
    }

    public TempFolder provide(RawScannerProperties scannerProps) {
        if (this.tempFolder == null) {
            String workingPathName = StringUtils.defaultIfBlank(scannerProps.property("sonar.globalWorking.directory"), "");
            Path workingPath = Paths.get(workingPathName, new String[0]);
            if (!workingPath.isAbsolute()) {
                Path home = this.findSonarHome(scannerProps);
                workingPath = home.resolve(workingPath).normalize();
            }
            try {
                GlobalTempFolderProvider.cleanTempFolders(workingPath);
            }
            catch (IOException e) {
                LOG.error(String.format("failed to clean global working directory: %s", workingPath), e);
            }
            Path tempDir = GlobalTempFolderProvider.createTempFolder(workingPath);
            this.tempFolder = new DefaultTempFolder(tempDir.toFile(), true);
        }
        return this.tempFolder;
    }

    private static Path createTempFolder(Path workingPath) {
        try {
            Path realPath = workingPath;
            if (Files.isSymbolicLink(realPath)) {
                realPath = realPath.toRealPath(new LinkOption[0]);
            }
            Files.createDirectories(realPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create working path: " + workingPath, e);
        }
        try {
            return Files.createTempDirectory(workingPath, TMP_NAME_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary folder in " + workingPath, e);
        }
    }

    private Path findSonarHome(RawScannerProperties props) {
        String home = props.property("sonar.userHome");
        if (home != null) {
            return Paths.get(home, new String[0]).toAbsolutePath();
        }
        home = this.system.envVariable("SONAR_USER_HOME");
        if (home != null) {
            return Paths.get(home, new String[0]).toAbsolutePath();
        }
        home = this.system.property("user.home");
        return Paths.get(home, ".sonar").toAbsolutePath();
    }

    private static void cleanTempFolders(Path path) throws IOException {
        if (path.toFile().exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, new CleanFilter());){
                for (Path p : stream) {
                    FileUtils.deleteQuietly(p.toFile());
                }
            }
        }
    }

    @Override
    public void start(PicoContainer container) {
        this.started = true;
    }

    @Override
    public void stop(PicoContainer container) {
        if (this.tempFolder != null) {
            this.tempFolder.stop();
        }
    }

    @Override
    public void dispose(PicoContainer container) {
    }

    @Override
    public boolean componentHasLifecycle() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private static class CleanFilter
    implements DirectoryStream.Filter<Path> {
        private CleanFilter() {
        }

        @Override
        public boolean accept(Path path) throws IOException {
            BasicFileAttributes attrs;
            if (!path.toFile().exists()) {
                return false;
            }
            if (!path.getFileName().toString().startsWith(GlobalTempFolderProvider.TMP_NAME_PREFIX)) {
                return false;
            }
            long threshold = System.currentTimeMillis() - CLEAN_MAX_AGE;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.error(String.format("Couldn't read file attributes for %s : ", path), ioe);
                return false;
            }
            long creationTime = attrs.creationTime().toMillis();
            return creationTime < threshold;
        }
    }
}

