/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.genericcoverage;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.component.Perspective;
import org.sonar.api.test.MutableTestCase;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.TestCase;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.genericcoverage.GenericCoverageReportParser;
import org.sonar.scanner.genericcoverage.StaxParser;

public class GenericTestExecutionReportParser {
    private static final String ROOT_ELEMENT = "testExecutions";
    private static final String OLD_ROOT_ELEMENT = "unitTest";
    private static final Logger LOG = Loggers.get(GenericTestExecutionReportParser.class);
    private static final String NAME_ATTR = "name";
    private static final String DURATION_ATTR = "duration";
    private static final String MESSAGE_ATTR = "message";
    public static final String OK = "ok";
    public static final String ERROR = "error";
    public static final String FAILURE = "failure";
    public static final String SKIPPED = "skipped";
    private static final int MAX_STORED_UNKNOWN_FILE_PATHS = 5;
    private final TestPlanBuilder testPlanBuilder;
    private int numberOfUnknownFiles;
    private final List<String> firstUnknownFiles = new ArrayList<String>();
    private final Set<String> matchedFileKeys = new HashSet<String>();

    public GenericTestExecutionReportParser(TestPlanBuilder testPlanBuilder) {
        this.testPlanBuilder = testPlanBuilder;
    }

    public void parse(File reportFile, SensorContext context) {
        try (FileInputStream inputStream = new FileInputStream(reportFile);){
            this.parse(inputStream, context);
        }
        catch (Exception e) {
            throw MessageException.of("Error during parsing of generic test execution report '" + reportFile + "'. Look at the SonarQube documentation to know the expected XML format.", e);
        }
    }

    private void parse(InputStream inputStream, SensorContext context) throws XMLStreamException {
        new StaxParser(rootCursor -> {
            rootCursor.advance();
            this.parseRootNode(rootCursor, context);
        }).parse(inputStream);
    }

    private void parseRootNode(SMHierarchicCursor rootCursor, SensorContext context) throws XMLStreamException {
        String version;
        String elementName = rootCursor.getLocalName();
        if (!OLD_ROOT_ELEMENT.equals(elementName) && !ROOT_ELEMENT.equals(elementName)) {
            throw new IllegalStateException("Unknown XML node, expected \"testExecutions\" but got \"" + elementName + "\" at line " + rootCursor.getCursorLocation().getLineNumber());
        }
        if (OLD_ROOT_ELEMENT.equals(elementName)) {
            LOG.warn("Using 'unitTest' as root element of the report is deprecated. Please change to 'testExecutions'.");
        }
        if (!"1".equals(version = rootCursor.getAttrValue("version"))) {
            throw new IllegalStateException("Unknown report version: " + version + ". This parser only handles version 1.");
        }
        this.parseFiles(rootCursor.childElementCursor(), context);
    }

    private void parseFiles(SMInputCursor fileCursor, SensorContext context) throws XMLStreamException {
        while (fileCursor.getNext() != null) {
            GenericCoverageReportParser.checkElementName(fileCursor, "file");
            String filePath = GenericCoverageReportParser.mandatoryAttribute(fileCursor, "path");
            InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(filePath));
            if (inputFile == null) {
                ++this.numberOfUnknownFiles;
                if (this.numberOfUnknownFiles > 5) continue;
                this.firstUnknownFiles.add(filePath);
                continue;
            }
            Preconditions.checkState(inputFile.language() != null, "Line %s of report refers to a file with an unknown language: %s", fileCursor.getCursorLocation().getLineNumber(), filePath);
            Preconditions.checkState(inputFile.type() != InputFile.Type.MAIN, "Line %s of report refers to a file which is not configured as a test file: %s", fileCursor.getCursorLocation().getLineNumber(), filePath);
            this.matchedFileKeys.add(inputFile.absolutePath());
            Perspective testPlan = this.testPlanBuilder.loadPerspective((Class)MutableTestPlan.class, (InputComponent)inputFile);
            SMInputCursor testCaseCursor = fileCursor.childElementCursor();
            while (testCaseCursor.getNext() != null) {
                this.parseTestCase(testCaseCursor, (MutableTestPlan)testPlan);
            }
        }
    }

    private void parseTestCase(SMInputCursor cursor, MutableTestPlan testPlan) throws XMLStreamException {
        GenericCoverageReportParser.checkElementName(cursor, "testCase");
        MutableTestCase testCase = testPlan.addTestCase(GenericCoverageReportParser.mandatoryAttribute(cursor, NAME_ATTR));
        TestCase.Status status = TestCase.Status.OK;
        testCase.setDurationInMs(GenericCoverageReportParser.longValue(GenericCoverageReportParser.mandatoryAttribute(cursor, DURATION_ATTR), cursor, DURATION_ATTR, 0L));
        SMInputCursor child = cursor.descendantElementCursor();
        if (child.getNext() != null) {
            String elementName = child.getLocalName();
            if (SKIPPED.equals(elementName)) {
                status = TestCase.Status.SKIPPED;
            } else if (FAILURE.equals(elementName)) {
                status = TestCase.Status.FAILURE;
            } else if (ERROR.equals(elementName)) {
                status = TestCase.Status.ERROR;
            }
            if (TestCase.Status.OK != status) {
                testCase.setMessage(GenericCoverageReportParser.mandatoryAttribute(child, MESSAGE_ATTR));
                testCase.setStackTrace(child.collectDescendantText());
            }
        }
        testCase.setStatus(status);
    }

    public int numberOfMatchedFiles() {
        return this.matchedFileKeys.size();
    }

    public int numberOfUnknownFiles() {
        return this.numberOfUnknownFiles;
    }

    public List<String> firstUnknownFiles() {
        return this.firstUnknownFiles;
    }
}

