/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.issue.ignore.IgnoreIssuesFilter;
import org.sonar.scanner.issue.ignore.pattern.BlockIssuePattern;
import org.sonar.scanner.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsRegexpScanner;

public final class IssueExclusionsLoader {
    private static final Logger LOG = Loggers.get(IssueExclusionsLoader.class);
    private final List<Pattern> allFilePatterns;
    private final List<DoubleRegexpMatcher> blockMatchers;
    private final IgnoreIssuesFilter ignoreIssuesFilter;
    private final AnalysisWarnings analysisWarnings;
    private final IssueExclusionPatternInitializer patternsInitializer;
    private final boolean enableCharHandler;
    private boolean warnDeprecatedIssuePatternAlreadyLogged;

    public IssueExclusionsLoader(IssueExclusionPatternInitializer patternsInitializer, IgnoreIssuesFilter ignoreIssuesFilter, AnalysisWarnings analysisWarnings) {
        this.patternsInitializer = patternsInitializer;
        this.ignoreIssuesFilter = ignoreIssuesFilter;
        this.analysisWarnings = analysisWarnings;
        this.allFilePatterns = new ArrayList<Pattern>();
        this.blockMatchers = new ArrayList<DoubleRegexpMatcher>();
        for (String string : patternsInitializer.getAllFilePatterns()) {
            this.allFilePatterns.add(Pattern.compile(string));
        }
        for (BlockIssuePattern blockIssuePattern : patternsInitializer.getBlockPatterns()) {
            this.blockMatchers.add(new DoubleRegexpMatcher(Pattern.compile(blockIssuePattern.getBeginBlockRegexp()), Pattern.compile(blockIssuePattern.getEndBlockRegexp())));
        }
        this.enableCharHandler = !this.allFilePatterns.isEmpty() || !this.blockMatchers.isEmpty();
    }

    public void addMulticriteriaPatterns(DefaultInputFile inputFile) {
        for (IssuePattern pattern : this.patternsInitializer.getMulticriteriaPatterns()) {
            if (pattern.matchFile(inputFile.getProjectRelativePath())) {
                this.ignoreIssuesFilter.addRuleExclusionPatternForComponent(inputFile, pattern.getRulePattern());
                continue;
            }
            if (!pattern.matchFile(inputFile.getModuleRelativePath())) continue;
            this.warnOnceDeprecatedIssuePattern("Specifying module-relative paths at project level in property 'sonar.issue.ignore.multicriteria' is deprecated. To continue matching files like '" + inputFile.getProjectRelativePath() + "', update this property so that patterns refer to project-relative paths.");
            this.ignoreIssuesFilter.addRuleExclusionPatternForComponent(inputFile, pattern.getRulePattern());
        }
    }

    private void warnOnceDeprecatedIssuePattern(String msg) {
        if (!this.warnDeprecatedIssuePatternAlreadyLogged) {
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
            this.warnDeprecatedIssuePatternAlreadyLogged = true;
        }
    }

    @CheckForNull
    public CharHandler createCharHandlerFor(DefaultInputFile inputFile) {
        if (this.enableCharHandler) {
            return new IssueExclusionsRegexpScanner(inputFile, this.allFilePatterns, this.blockMatchers);
        }
        return null;
    }

    public String toString() {
        return "Issues Exclusions - Source Scanner";
    }

    public static class DoubleRegexpMatcher {
        private Pattern firstPattern;
        private Pattern secondPattern;

        DoubleRegexpMatcher(Pattern firstPattern, Pattern secondPattern) {
            this.firstPattern = firstPattern;
            this.secondPattern = secondPattern;
        }

        boolean matchesFirstPattern(String line) {
            return this.firstPattern.matcher(line).find();
        }

        boolean matchesSecondPattern(String line) {
            return this.hasSecondPattern() && this.secondPattern.matcher(line).find();
        }

        boolean hasSecondPattern() {
            return StringUtils.isNotEmpty(this.secondPattern.toString());
        }
    }
}

