/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.protocol.input;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.scanner.protocol.input.FileData;
import org.sonar.scanner.protocol.input.ProjectRepositories;
import org.sonar.scanner.protocol.input.SingleProjectRepository;

public class MultiModuleProjectRepository
implements ProjectRepositories {
    private Map<String, SingleProjectRepository> repositoryPerModule = Maps.newHashMap();

    public MultiModuleProjectRepository addFileDataToModule(String moduleKey, @Nullable String path, FileData fileData) {
        if (path == null || fileData.hash() == null && fileData.revision() == null) {
            return this;
        }
        SingleProjectRepository repository = this.repositoryPerModule.computeIfAbsent(moduleKey, k -> new SingleProjectRepository());
        repository.addFileData(path, fileData);
        return this;
    }

    public Map<String, SingleProjectRepository> repositoriesByModule() {
        return this.repositoryPerModule;
    }

    @CheckForNull
    public FileData fileData(String moduleKeyWithBranch, @Nullable String path) {
        Optional<SingleProjectRepository> moduleRepository = Optional.ofNullable(this.repositoryPerModule.get(moduleKeyWithBranch));
        return moduleRepository.map(singleProjectRepository -> singleProjectRepository.fileDataByPath(path)).orElse(null);
    }
}

