/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.io.File;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.ProjectInfo;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.rule.QProfile;
import org.sonar.scanner.rule.QualityProfiles;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonar.scanner.scm.ScmConfiguration;

public class MetadataPublisher
implements ReportPublisherStep {
    private static final Logger LOG = Loggers.get(MetadataPublisher.class);
    private final ScanProperties properties;
    private final QualityProfiles qProfiles;
    private final ProjectInfo projectInfo;
    private final InputModuleHierarchy moduleHierarchy;
    private final CpdSettings cpdSettings;
    private final ScannerPluginRepository pluginRepository;
    private final BranchConfiguration branchConfiguration;
    @Nullable
    private final ScmConfiguration scmConfiguration;

    public MetadataPublisher(ProjectInfo projectInfo, InputModuleHierarchy moduleHierarchy, ScanProperties properties, QualityProfiles qProfiles, CpdSettings cpdSettings, ScannerPluginRepository pluginRepository, BranchConfiguration branchConfiguration, @Nullable ScmConfiguration scmConfiguration) {
        this.projectInfo = projectInfo;
        this.moduleHierarchy = moduleHierarchy;
        this.properties = properties;
        this.qProfiles = qProfiles;
        this.cpdSettings = cpdSettings;
        this.pluginRepository = pluginRepository;
        this.branchConfiguration = branchConfiguration;
        this.scmConfiguration = scmConfiguration;
    }

    public MetadataPublisher(ProjectInfo projectInfo, InputModuleHierarchy moduleHierarchy, ScanProperties properties, QualityProfiles qProfiles, CpdSettings cpdSettings, ScannerPluginRepository pluginRepository, BranchConfiguration branchConfiguration) {
        this(projectInfo, moduleHierarchy, properties, qProfiles, cpdSettings, pluginRepository, branchConfiguration, null);
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        DefaultInputModule rootProject = this.moduleHierarchy.root();
        ScannerReport.Metadata.Builder builder = ScannerReport.Metadata.newBuilder().setAnalysisDate(this.projectInfo.getAnalysisDate().getTime()).setProjectKey(rootProject.key()).setCrossProjectDuplicationActivated(this.cpdSettings.isCrossProjectDuplicationEnabled()).setRootComponentRef(rootProject.scannerId());
        this.projectInfo.getProjectVersion().ifPresent(builder::setProjectVersion);
        this.projectInfo.getBuildString().ifPresent(builder::setBuildString);
        this.properties.organizationKey().ifPresent(builder::setOrganizationKey);
        if (this.branchConfiguration.branchName() != null) {
            this.addBranchInformation(builder);
        }
        Optional.ofNullable(rootProject.getBranch()).ifPresent(builder::setDeprecatedBranch);
        if (this.scmConfiguration != null) {
            this.addScmInformation(builder);
        }
        for (QProfile qProfile : this.qProfiles.findAll()) {
            builder.putQprofilesPerLanguage(qProfile.getLanguage(), ScannerReport.Metadata.QProfile.newBuilder().setKey(qProfile.getKey()).setLanguage(qProfile.getLanguage()).setName(qProfile.getName()).setRulesUpdatedAt(qProfile.getRulesUpdatedAt().getTime()).build());
        }
        for (Map.Entry entry : this.pluginRepository.getPluginsByKey().entrySet()) {
            builder.putPluginsByKey((String)entry.getKey(), ScannerReport.Metadata.Plugin.newBuilder().setKey((String)entry.getKey()).setUpdatedAt(((ScannerPlugin)entry.getValue()).getUpdatedAt()).build());
        }
        this.addModulesRelativePaths(builder);
        writer.writeMetadata(builder.build());
    }

    private void addModulesRelativePaths(ScannerReport.Metadata.Builder builder) {
        LinkedList<DefaultInputModule> queue = new LinkedList<DefaultInputModule>();
        queue.add(this.moduleHierarchy.root());
        while (!queue.isEmpty()) {
            DefaultInputModule module = (DefaultInputModule)queue.removeFirst();
            queue.addAll(this.moduleHierarchy.children(module));
            String relativePath = this.moduleHierarchy.relativePathToRoot(module);
            if (relativePath == null) continue;
            builder.putModulesProjectRelativePathByKey(module.key(), relativePath);
        }
    }

    private void addScmInformation(ScannerReport.Metadata.Builder builder) {
        ScmProvider scmProvider = this.scmConfiguration.provider();
        if (scmProvider != null) {
            Path projectBasedir = this.moduleHierarchy.root().getBaseDir();
            try {
                builder.setRelativePathFromScmRoot(MetadataPublisher.toSonarQubePath(scmProvider.relativePathFromScmRoot(projectBasedir)));
            }
            catch (UnsupportedOperationException e) {
                LOG.debug(e.getMessage());
            }
            try {
                builder.setScmRevisionId(scmProvider.revisionId(projectBasedir));
            }
            catch (UnsupportedOperationException e) {
                LOG.debug(e.getMessage());
            }
        }
    }

    private void addBranchInformation(ScannerReport.Metadata.Builder builder) {
        builder.setBranchName(this.branchConfiguration.branchName());
        ScannerReport.Metadata.BranchType branchType = MetadataPublisher.toProtobufBranchType(this.branchConfiguration.branchType());
        builder.setBranchType(branchType);
        String referenceBranch = this.branchConfiguration.longLivingSonarReferenceBranch();
        if (referenceBranch != null) {
            builder.setMergeBranchName(referenceBranch);
        }
        if (branchType == ScannerReport.Metadata.BranchType.PULL_REQUEST) {
            builder.setPullRequestKey(this.branchConfiguration.pullRequestKey());
        }
    }

    private static ScannerReport.Metadata.BranchType toProtobufBranchType(BranchType branchType) {
        if (branchType == BranchType.PULL_REQUEST) {
            return ScannerReport.Metadata.BranchType.PULL_REQUEST;
        }
        if (branchType == BranchType.LONG) {
            return ScannerReport.Metadata.BranchType.LONG;
        }
        return ScannerReport.Metadata.BranchType.SHORT;
    }

    private static String toSonarQubePath(Path path) {
        String pathAsString = path.toString();
        char sonarQubeSeparatorChar = '/';
        if (File.separatorChar != sonarQubeSeparatorChar) {
            return pathAsString.replaceAll(Pattern.quote(File.separator), String.valueOf(sonarQubeSeparatorChar));
        }
        return pathAsString;
    }
}

