/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.MultiModuleProjectRepository;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.repository.SingleProjectRepository;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.Batch;
import org.sonarqube.ws.client.HttpException;

public class DefaultProjectRepositoriesLoader
implements ProjectRepositoriesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectRepositoriesLoader.class);
    private static final String BATCH_PROJECT_URL = "/batch/project.protobuf";
    private final ScannerWsClient wsClient;

    public DefaultProjectRepositoriesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ProjectRepositories load(String projectKey, @Nullable String branchBase) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getUrl(String projectKey, @Nullable String branchBase) {
        StringBuilder builder = new StringBuilder();
        builder.append(BATCH_PROJECT_URL).append("?key=").append(ScannerUtils.encodeForUrl(projectKey));
        if (branchBase != null) {
            builder.append("&branch=").append(branchBase);
        }
        return builder.toString();
    }

    private static boolean shouldThrow(Exception e) {
        for (Throwable t : Throwables.getCausalChain(e)) {
            if (t instanceof HttpException) {
                HttpException http = (HttpException)t;
                return http.code() != 404;
            }
            if (!(t instanceof MessageException)) continue;
            return true;
        }
        return false;
    }

    private static ProjectRepositories processStream(InputStream is) throws IOException {
        Batch.WsProjectResponse response = Batch.WsProjectResponse.parseFrom(is);
        if (response.getFileDataByModuleAndPathCount() == 0) {
            return new SingleProjectRepository(DefaultProjectRepositoriesLoader.constructFileDataMap(response.getFileDataByPathMap()));
        }
        HashMap<String, SingleProjectRepository> repositoriesPerModule = new HashMap<String, SingleProjectRepository>();
        response.getFileDataByModuleAndPathMap().keySet().forEach(moduleKey -> {
            Batch.WsProjectResponse.FileDataByPath filePaths = response.getFileDataByModuleAndPathMap().get(moduleKey);
            repositoriesPerModule.put((String)moduleKey, new SingleProjectRepository(DefaultProjectRepositoriesLoader.constructFileDataMap(filePaths.getFileDataByPathMap())));
        });
        return new MultiModuleProjectRepository(repositoriesPerModule);
    }

    private static Map<String, FileData> constructFileDataMap(Map<String, Batch.WsProjectResponse.FileData> content) {
        HashMap<String, FileData> fileDataMap = new HashMap<String, FileData>();
        content.forEach((key, value) -> {
            FileData fd = new FileData(value.getHash(), value.getRevision());
            fileDataMap.put((String)key, fd);
        });
        return fileDataMap;
    }
}

