/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.LoadedActiveRule;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.GetRequest;

public class DefaultActiveRulesLoader
implements ActiveRulesLoader {
    private static final String RULES_SEARCH_URL = "/api/rules/search.protobuf?f=repo,name,severity,lang,internalKey,templateKey,params,actives,createdAt,updatedAt&activation=true";
    private static final String RULES_SEARCH_NO_HOTSPOT_URL = "/api/rules/search.protobuf?f=repo,name,severity,lang,internalKey,templateKey,params,actives,createdAt,updatedAt&activation=true&types=" + Arrays.stream(RuleType.values()).filter(t -> t != RuleType.SECURITY_HOTSPOT).map(Enum::name).collect(Collectors.joining(","));
    private final ScannerWsClient wsClient;
    private final BranchConfiguration branchConfiguration;

    public DefaultActiveRulesLoader(ScannerWsClient wsClient, BranchConfiguration branchConfiguration) {
        this.wsClient = wsClient;
        this.branchConfiguration = branchConfiguration;
    }

    @Override
    public List<LoadedActiveRule> load(String qualityProfileKey) {
        LinkedList<LoadedActiveRule> ruleList = new LinkedList<LoadedActiveRule>();
        int page = 1;
        int pageSize = 500;
        long loaded = 0L;
        while (true) {
            GetRequest getRequest = new GetRequest(this.getUrl(qualityProfileKey, page, pageSize));
            Rules.SearchResponse response = DefaultActiveRulesLoader.loadFromStream(this.wsClient.call(getRequest).contentStream());
            List<LoadedActiveRule> pageRules = DefaultActiveRulesLoader.readPage(response);
            ruleList.addAll(pageRules);
            if (response.getTotal() <= (loaded += response.getPs())) break;
            ++page;
        }
        return ruleList;
    }

    private String getUrl(String qualityProfileKey, int page, int pageSize) {
        StringBuilder builder = new StringBuilder(1024);
        if (this.branchConfiguration.isShortOrPullRequest()) {
            builder.append(RULES_SEARCH_NO_HOTSPOT_URL);
        } else {
            builder.append(RULES_SEARCH_URL);
        }
        builder.append("&qprofile=").append(ScannerUtils.encodeForUrl(qualityProfileKey));
        builder.append("&p=").append(page);
        builder.append("&ps=").append(pageSize);
        return builder.toString();
    }

    private static Rules.SearchResponse loadFromStream(InputStream is) {
        try {
            Rules.SearchResponse searchResponse = Rules.SearchResponse.parseFrom(is);
            return searchResponse;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load quality profiles", e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private static List<LoadedActiveRule> readPage(Rules.SearchResponse response) {
        LinkedList<LoadedActiveRule> loadedRules = new LinkedList<LoadedActiveRule>();
        List<Rules.Rule> rulesList = response.getRulesList();
        Map<String, Rules.ActiveList> actives = response.getActives().getActives();
        for (Rules.Rule r : rulesList) {
            Rules.ActiveList activeList = actives.get(r.getKey());
            Rules.Active active = activeList.getActiveList(0);
            LoadedActiveRule loadedRule = new LoadedActiveRule();
            loadedRule.setRuleKey(RuleKey.parse(r.getKey()));
            loadedRule.setName(r.getName());
            loadedRule.setSeverity(active.getSeverity());
            loadedRule.setCreatedAt(DateUtils.dateToLong(DateUtils.parseDateTime(active.getCreatedAt())));
            loadedRule.setUpdatedAt(DateUtils.dateToLong(DateUtils.parseDateTime(active.getUpdatedAt())));
            loadedRule.setLanguage(r.getLang());
            loadedRule.setInternalKey(r.getInternalKey());
            if (r.hasTemplateKey()) {
                RuleKey templateRuleKey = RuleKey.parse(r.getTemplateKey());
                loadedRule.setTemplateRuleKey(templateRuleKey.rule());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (Rules.Rule.Param param : r.getParams().getParamsList()) {
                params.put(param.getKey(), param.getDefaultValue());
            }
            for (Rules.Active.Param param : active.getParamsList()) {
                params.put(param.getKey(), param.getValue());
            }
            loadedRule.setParams(params);
            loadedRules.add(loadedRule);
        }
        return loadedRules;
    }
}

