/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.MessageException;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.scan.branch.BranchParamsValidator;

public class ProjectReactorValidator {
    private final AnalysisMode mode;
    private final GlobalConfiguration settings;
    @Nullable
    private final BranchParamsValidator branchParamsValidator;

    public ProjectReactorValidator(AnalysisMode mode, GlobalConfiguration settings, @Nullable BranchParamsValidator branchParamsValidator) {
        this.mode = mode;
        this.settings = settings;
        this.branchParamsValidator = branchParamsValidator;
    }

    public ProjectReactorValidator(AnalysisMode mode, GlobalConfiguration settings) {
        this(mode, settings, null);
    }

    public void validate(ProjectReactor reactor) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            if (this.mode.isIssues()) {
                ProjectReactorValidator.validateModuleIssuesMode(moduleDef, validationMessages);
                continue;
            }
            ProjectReactorValidator.validateModule(moduleDef, validationMessages);
        }
        String deprecatedBranchName = reactor.getRoot().getBranch();
        if (this.isBranchFeatureAvailable()) {
            this.branchParamsValidator.validate(validationMessages, deprecatedBranchName);
        } else {
            this.validateBranchParamsWhenPluginAbsent(validationMessages);
            this.validatePullRequestParamsWhenPluginAbsent(validationMessages);
        }
        ProjectReactorValidator.validateLegacyBranch(validationMessages, deprecatedBranchName);
        if (!validationMessages.isEmpty()) {
            throw MessageException.of("Validation of project reactor failed:\n  o " + Joiner.on("\n  o ").join(validationMessages));
        }
    }

    private void validateBranchParamsWhenPluginAbsent(List<String> validationMessages) {
        for (String param : Arrays.asList("sonar.branch.name", "sonar.branch.target")) {
            if (!StringUtils.isNotEmpty(this.settings.get(param).orElse(null))) continue;
            validationMessages.add(String.format("To use the property \"%s\", the branch plugin is required but not installed. See the documentation of branch support: %s.", param, "https://redirect.sonarsource.com/doc/branches.html"));
        }
    }

    private void validatePullRequestParamsWhenPluginAbsent(List<String> validationMessages) {
        Stream.of("sonar.pullrequest.key", "sonar.pullrequest.branch", "sonar.pullrequest.base").filter(param -> Objects.nonNull(this.settings.get((String)param).orElse(null))).forEach(param -> validationMessages.add(String.format("To use the property \"%s\", the branch plugin is required but not installed. See the documentation of branch support: %s.", param, "https://redirect.sonarsource.com/doc/branches.html")));
    }

    private static void validateModuleIssuesMode(ProjectDefinition moduleDef, List<String> validationMessages) {
        if (!ComponentKeys.isValidProjectKeyIssuesMode(moduleDef.getKey())) {
            validationMessages.add(String.format("\"%s\" is not a valid project or module key. Allowed characters in issues mode are alphanumeric, '-', '_', '.', '/' and ':', with at least one non-digit.", moduleDef.getKey()));
        }
    }

    private static void validateModule(ProjectDefinition moduleDef, List<String> validationMessages) {
        if (!ComponentKeys.isValidProjectKey(moduleDef.getKey())) {
            validationMessages.add(String.format("\"%s\" is not a valid project or module key. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", moduleDef.getKey()));
        }
    }

    private static void validateLegacyBranch(List<String> validationMessages, @Nullable String branch) {
        if (StringUtils.isNotEmpty(branch) && !ComponentKeys.isValidLegacyBranch(branch)) {
            validationMessages.add(String.format("\"%s\" is not a valid branch name. Allowed characters are alphanumeric, '-', '_', '.' and '/'.", branch));
        }
    }

    private boolean isBranchFeatureAvailable() {
        return this.branchParamsValidator != null;
    }
}

