/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationLoader;
import org.sonar.scanner.scan.branch.DefaultBranchConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonar.scanner.scan.branch.ProjectPullRequests;

public class BranchConfigurationProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(BranchConfigurationProvider.class);
    private static final String LOG_MSG = "Load branch configuration";
    private BranchConfiguration branchConfiguration = null;

    public BranchConfiguration provide(@Nullable BranchConfigurationLoader loader, GlobalConfiguration globalConfiguration, ProjectReactor reactor, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings, ProjectBranches branches, ProjectPullRequests pullRequests) {
        if (this.branchConfiguration == null) {
            if (loader == null) {
                this.branchConfiguration = new DefaultBranchConfiguration();
            } else {
                Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
                Supplier<Map<String, String>> settingsSupplier = BranchConfigurationProvider.createSettingsSupplier(reactor.getRoot(), globalServerSettings, projectServerSettings);
                this.branchConfiguration = loader.load(globalConfiguration.getProperties(), settingsSupplier, branches, pullRequests);
                profiler.stopInfo();
            }
        }
        return this.branchConfiguration;
    }

    private static Supplier<Map<String, String>> createSettingsSupplier(ProjectDefinition root, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings) {
        return () -> {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.putAll(globalServerSettings.properties());
            settings.putAll(projectServerSettings.properties());
            settings.putAll(root.properties());
            return settings;
        };
    }
}

