/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.Collections;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonar.scanner.scan.branch.ProjectBranchesLoader;

public class ProjectBranchesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ProjectBranchesProvider.class);
    private static final String LOG_MSG = "Load project branches";
    private ProjectBranches branches = null;

    public ProjectBranches provide(@Nullable ProjectBranchesLoader loader, ProjectKey projectKey) {
        if (this.branches != null) {
            return this.branches;
        }
        if (loader == null) {
            this.branches = new ProjectBranches(Collections.emptyList());
            return this.branches;
        }
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        this.branches = loader.load(projectKey.get());
        profiler.stopInfo();
        return this.branches;
    }
}

