/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public abstract class AbstractExclusionFilters {
    private static final Logger LOG = Loggers.get(AbstractExclusionFilters.class);
    private final String[] sourceInclusions;
    private final String[] testInclusions;
    private final String[] sourceExclusions;
    private final String[] testExclusions;
    private PathPattern[] mainInclusionsPattern;
    private PathPattern[] mainExclusionsPattern;
    private PathPattern[] testInclusionsPattern;
    private PathPattern[] testExclusionsPattern;

    public AbstractExclusionFilters(Function<String, String[]> configProvider) {
        this.sourceInclusions = this.inclusions(configProvider, "sonar.inclusions");
        this.testInclusions = this.inclusions(configProvider, "sonar.test.inclusions");
        this.sourceExclusions = this.exclusions(configProvider, "sonar.global.exclusions", "sonar.exclusions");
        this.testExclusions = this.exclusions(configProvider, "sonar.global.test.exclusions", "sonar.test.exclusions");
        this.mainInclusionsPattern = AbstractExclusionFilters.prepareMainInclusions(this.sourceInclusions);
        this.mainExclusionsPattern = AbstractExclusionFilters.prepareMainExclusions(this.sourceExclusions, this.testInclusions);
        this.testInclusionsPattern = AbstractExclusionFilters.prepareTestInclusions(this.testInclusions);
        this.testExclusionsPattern = AbstractExclusionFilters.prepareTestExclusions(this.testExclusions);
    }

    public void log(String indent) {
        AbstractExclusionFilters.log("Included sources:", this.mainInclusionsPattern, indent);
        AbstractExclusionFilters.log("Excluded sources:", this.mainExclusionsPattern, indent);
        AbstractExclusionFilters.log("Included tests:", this.testInclusionsPattern, indent);
        AbstractExclusionFilters.log("Excluded tests:", this.testExclusionsPattern, indent);
    }

    private String[] inclusions(Function<String, String[]> configProvider, String propertyKey) {
        return (String[])Arrays.stream((Object[])configProvider.apply(propertyKey)).map(StringUtils::trim).filter(s -> !"**/*".equals(s)).filter(s -> !"file:**/*".equals(s)).toArray(String[]::new);
    }

    private String[] exclusions(Function<String, String[]> configProvider, String globalExclusionsProperty, String exclusionsProperty) {
        String[] globalExclusions = configProvider.apply(globalExclusionsProperty);
        String[] exclusions = configProvider.apply(exclusionsProperty);
        return (String[])Stream.concat(Arrays.stream(globalExclusions), Arrays.stream(exclusions)).map(StringUtils::trim).toArray(String[]::new);
    }

    public boolean hasPattern() {
        return this.mainInclusionsPattern.length > 0 || this.mainExclusionsPattern.length > 0 || this.testInclusionsPattern.length > 0 || this.testExclusionsPattern.length > 0;
    }

    private static void log(String title, PathPattern[] patterns, String indent) {
        if (patterns.length > 0) {
            LOG.info("{}{} {}", indent, title, Arrays.stream(patterns).map(Object::toString).collect(Collectors.joining(", ")));
        }
    }

    private static PathPattern[] prepareMainInclusions(String[] sourceInclusions) {
        if (sourceInclusions.length > 0) {
            return PathPattern.create(sourceInclusions);
        }
        return new PathPattern[0];
    }

    private static PathPattern[] prepareTestInclusions(String[] testInclusions) {
        return PathPattern.create(testInclusions);
    }

    static PathPattern[] prepareMainExclusions(String[] sourceExclusions, String[] testInclusions) {
        String[] patterns = (String[])ArrayUtils.addAll(sourceExclusions, testInclusions);
        return PathPattern.create(patterns);
    }

    private static PathPattern[] prepareTestExclusions(String[] testExclusions) {
        return PathPattern.create(testExclusions);
    }

    public String[] getInclusionsConfig(InputFile.Type type) {
        return type == InputFile.Type.MAIN ? this.sourceInclusions : this.testInclusions;
    }

    public String[] getExclusionsConfig(InputFile.Type type) {
        return type == InputFile.Type.MAIN ? this.sourceExclusions : this.testExclusions;
    }

    public boolean isIncluded(Path absolutePath, Path relativePath, InputFile.Type type) {
        PathPattern[] inclusionPatterns;
        PathPattern[] pathPatternArray = inclusionPatterns = InputFile.Type.MAIN == type ? this.mainInclusionsPattern : this.testInclusionsPattern;
        if (inclusionPatterns.length == 0) {
            return true;
        }
        for (PathPattern pattern : inclusionPatterns) {
            if (!pattern.match(absolutePath, relativePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(Path absolutePath, Path relativePath, InputFile.Type type) {
        PathPattern[] exclusionPatterns;
        PathPattern[] pathPatternArray = exclusionPatterns = InputFile.Type.MAIN == type ? this.mainExclusionsPattern : this.testExclusionsPattern;
        if (exclusionPatterns.length == 0) {
            return false;
        }
        for (PathPattern pattern : exclusionPatterns) {
            if (!pattern.match(absolutePath, relativePath)) continue;
            return true;
        }
        return false;
    }
}

