/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.batch.scm.IgnoreCommand;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;
import org.sonar.scanner.scan.filesystem.ModuleCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ModuleExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectFileIndexer;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;
import org.sonar.scanner.util.ProgressReport;

public class FileIndexer {
    private static final Logger LOG = Loggers.get(FileIndexer.class);
    private final AnalysisWarnings analysisWarnings;
    private final ScanProperties properties;
    private final InputFileFilter[] filters;
    private final ProjectExclusionFilters projectExclusionFilters;
    private final ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions;
    private final IssueExclusionsLoader issueExclusionsLoader;
    private final MetadataGenerator metadataGenerator;
    private final DefaultInputProject project;
    private final ScannerComponentIdGenerator scannerComponentIdGenerator;
    private final InputComponentStore componentStore;
    private final SensorStrategy sensorStrategy;
    private final LanguageDetection langDetection;
    private boolean warnInclusionsAlreadyLogged;
    private boolean warnExclusionsAlreadyLogged;
    private boolean warnCoverageExclusionsAlreadyLogged;
    private boolean warnDuplicationExclusionsAlreadyLogged;

    public FileIndexer(DefaultInputProject project, ScannerComponentIdGenerator scannerComponentIdGenerator, InputComponentStore componentStore, ProjectExclusionFilters projectExclusionFilters, ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions, IssueExclusionsLoader issueExclusionsLoader, MetadataGenerator metadataGenerator, SensorStrategy sensorStrategy, LanguageDetection languageDetection, AnalysisWarnings analysisWarnings, ScanProperties properties, InputFileFilter[] filters) {
        this.project = project;
        this.scannerComponentIdGenerator = scannerComponentIdGenerator;
        this.componentStore = componentStore;
        this.projectCoverageAndDuplicationExclusions = projectCoverageAndDuplicationExclusions;
        this.issueExclusionsLoader = issueExclusionsLoader;
        this.metadataGenerator = metadataGenerator;
        this.sensorStrategy = sensorStrategy;
        this.langDetection = languageDetection;
        this.analysisWarnings = analysisWarnings;
        this.properties = properties;
        this.filters = filters;
        this.projectExclusionFilters = projectExclusionFilters;
    }

    public FileIndexer(DefaultInputProject project, ScannerComponentIdGenerator scannerComponentIdGenerator, InputComponentStore componentStore, ProjectExclusionFilters projectExclusionFilters, ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions, IssueExclusionsLoader issueExclusionsLoader, MetadataGenerator metadataGenerator, SensorStrategy sensorStrategy, LanguageDetection languageDetection, AnalysisWarnings analysisWarnings, ScanProperties properties) {
        this(project, scannerComponentIdGenerator, componentStore, projectExclusionFilters, projectCoverageAndDuplicationExclusions, issueExclusionsLoader, metadataGenerator, sensorStrategy, languageDetection, analysisWarnings, properties, new InputFileFilter[0]);
    }

    void indexFile(DefaultInputModule module, ModuleExclusionFilters moduleExclusionFilters, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, Path sourceFile, InputFile.Type type, ProgressReport progressReport, ProjectFileIndexer.ExclusionCounter exclusionCounter, @Nullable IgnoreCommand ignoreCommand) throws IOException {
        Path moduleRelativePath;
        Path realAbsoluteFile = sourceFile.toRealPath(LinkOption.NOFOLLOW_LINKS).toAbsolutePath().normalize();
        if (!realAbsoluteFile.startsWith(this.project.getBaseDir())) {
            LOG.warn("File '{}' is ignored. It is not located in project basedir '{}'.", (Object)realAbsoluteFile.toAbsolutePath(), (Object)this.project.getBaseDir());
            return;
        }
        if (!realAbsoluteFile.startsWith(module.getBaseDir())) {
            LOG.warn("File '{}' is ignored. It is not located in module basedir '{}'.", (Object)realAbsoluteFile.toAbsolutePath(), (Object)module.getBaseDir());
            return;
        }
        Path projectRelativePath = this.project.getBaseDir().relativize(realAbsoluteFile);
        boolean included = this.evaluateInclusionsFilters(moduleExclusionFilters, realAbsoluteFile, projectRelativePath, moduleRelativePath = module.getBaseDir().relativize(realAbsoluteFile), type);
        if (!included) {
            exclusionCounter.increaseByPatternsCount();
            return;
        }
        boolean excluded = this.evaluateExclusionsFilters(moduleExclusionFilters, realAbsoluteFile, projectRelativePath, moduleRelativePath, type);
        if (excluded) {
            exclusionCounter.increaseByPatternsCount();
            return;
        }
        String language = this.langDetection.language(realAbsoluteFile, projectRelativePath);
        if (ignoreCommand != null && ignoreCommand.isIgnored(realAbsoluteFile)) {
            LOG.debug("File '{}' is excluded by the scm ignore settings.", (Object)realAbsoluteFile);
            exclusionCounter.increaseByScmCount();
            return;
        }
        DefaultIndexedFile indexedFile = new DefaultIndexedFile(realAbsoluteFile, this.project.key(), projectRelativePath.toString(), moduleRelativePath.toString(), type, language, this.scannerComponentIdGenerator.getAsInt(), this.sensorStrategy);
        DefaultInputFile inputFile = new DefaultInputFile(indexedFile, f -> this.metadataGenerator.setMetadata(module.getKeyWithBranch(), (DefaultInputFile)f, module.getEncoding()));
        if (language != null) {
            inputFile.setPublished(true);
        }
        if (!this.accept(inputFile)) {
            return;
        }
        this.checkIfAlreadyIndexed(inputFile);
        this.componentStore.put(module.key(), inputFile);
        this.issueExclusionsLoader.addMulticriteriaPatterns(inputFile);
        LOG.debug("'{}' indexed {}with language '{}'", projectRelativePath, type == InputFile.Type.TEST ? "as test " : "", inputFile.language());
        this.evaluateCoverageExclusions(moduleCoverageAndDuplicationExclusions, inputFile);
        this.evaluateDuplicationExclusions(moduleCoverageAndDuplicationExclusions, inputFile);
        if (this.properties.preloadFileMetadata()) {
            inputFile.checkMetadata();
        }
        int count = this.componentStore.inputFiles().size();
        progressReport.message(count + " " + FileIndexer.pluralizeFiles(count) + " indexed...  (last one was " + inputFile.getProjectRelativePath() + ")");
    }

    private boolean evaluateInclusionsFilters(ModuleExclusionFilters moduleExclusionFilters, Path realAbsoluteFile, Path projectRelativePath, Path moduleRelativePath, InputFile.Type type) {
        if (!Arrays.equals(moduleExclusionFilters.getInclusionsConfig(type), this.projectExclusionFilters.getInclusionsConfig(type))) {
            return moduleExclusionFilters.isIncluded(realAbsoluteFile, moduleRelativePath, type);
        }
        boolean includedByProjectConfiguration = this.projectExclusionFilters.isIncluded(realAbsoluteFile, projectRelativePath, type);
        if (includedByProjectConfiguration) {
            return true;
        }
        if (moduleExclusionFilters.isIncluded(realAbsoluteFile, moduleRelativePath, type)) {
            this.warnOnce(type == InputFile.Type.MAIN ? "sonar.inclusions" : "sonar.test.inclusions", FilenameUtils.normalize(projectRelativePath.toString(), true), () -> this.warnInclusionsAlreadyLogged, () -> {
                this.warnInclusionsAlreadyLogged = true;
            });
            return true;
        }
        return false;
    }

    private boolean evaluateExclusionsFilters(ModuleExclusionFilters moduleExclusionFilters, Path realAbsoluteFile, Path projectRelativePath, Path moduleRelativePath, InputFile.Type type) {
        if (!Arrays.equals(moduleExclusionFilters.getExclusionsConfig(type), this.projectExclusionFilters.getExclusionsConfig(type))) {
            return moduleExclusionFilters.isExcluded(realAbsoluteFile, moduleRelativePath, type);
        }
        boolean includedByProjectConfiguration = this.projectExclusionFilters.isExcluded(realAbsoluteFile, projectRelativePath, type);
        if (includedByProjectConfiguration) {
            return true;
        }
        if (moduleExclusionFilters.isExcluded(realAbsoluteFile, moduleRelativePath, type)) {
            this.warnOnce(type == InputFile.Type.MAIN ? "sonar.exclusions" : "sonar.test.exclusions", FilenameUtils.normalize(projectRelativePath.toString(), true), () -> this.warnExclusionsAlreadyLogged, () -> {
                this.warnExclusionsAlreadyLogged = true;
            });
            return true;
        }
        return false;
    }

    private void checkIfAlreadyIndexed(DefaultInputFile inputFile) {
        if (this.componentStore.inputFile(inputFile.getProjectRelativePath()) != null) {
            throw MessageException.of("File " + inputFile + " can't be indexed twice. Please check that inclusion/exclusion patterns produce disjoint sets for main and test files");
        }
    }

    private void evaluateCoverageExclusions(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        boolean excludedForCoverage = this.isExcludedForCoverage(moduleCoverageAndDuplicationExclusions, inputFile);
        inputFile.setExcludedForCoverage(excludedForCoverage);
        if (excludedForCoverage) {
            LOG.debug("File {} excluded for coverage", (Object)inputFile);
        }
    }

    private boolean isExcludedForCoverage(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        if (!Arrays.equals(moduleCoverageAndDuplicationExclusions.getCoverageExclusionConfig(), this.projectCoverageAndDuplicationExclusions.getCoverageExclusionConfig())) {
            return moduleCoverageAndDuplicationExclusions.isExcludedForCoverage(inputFile);
        }
        boolean excludedByProjectConfiguration = this.projectCoverageAndDuplicationExclusions.isExcludedForCoverage(inputFile);
        if (excludedByProjectConfiguration) {
            return true;
        }
        if (moduleCoverageAndDuplicationExclusions.isExcludedForCoverage(inputFile)) {
            this.warnOnce("sonar.coverage.exclusions", inputFile.getProjectRelativePath(), () -> this.warnCoverageExclusionsAlreadyLogged, () -> {
                this.warnCoverageExclusionsAlreadyLogged = true;
            });
            return true;
        }
        return false;
    }

    private void evaluateDuplicationExclusions(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        boolean excludedForDuplications = this.isExcludedForDuplications(moduleCoverageAndDuplicationExclusions, inputFile);
        inputFile.setExcludedForDuplication(excludedForDuplications);
        if (excludedForDuplications) {
            LOG.debug("File {} excluded for duplication", (Object)inputFile);
        }
    }

    private boolean isExcludedForDuplications(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        if (!Arrays.equals(moduleCoverageAndDuplicationExclusions.getDuplicationExclusionConfig(), this.projectCoverageAndDuplicationExclusions.getDuplicationExclusionConfig())) {
            return moduleCoverageAndDuplicationExclusions.isExcludedForDuplication(inputFile);
        }
        boolean excludedByProjectConfiguration = this.projectCoverageAndDuplicationExclusions.isExcludedForDuplication(inputFile);
        if (excludedByProjectConfiguration) {
            return true;
        }
        if (moduleCoverageAndDuplicationExclusions.isExcludedForDuplication(inputFile)) {
            this.warnOnce("sonar.cpd.exclusions", inputFile.getProjectRelativePath(), () -> this.warnDuplicationExclusionsAlreadyLogged, () -> {
                this.warnDuplicationExclusionsAlreadyLogged = true;
            });
            return true;
        }
        return false;
    }

    private void warnOnce(String propKey, String filePath, BooleanSupplier alreadyLoggedGetter, Runnable markAsLogged) {
        if (!alreadyLoggedGetter.getAsBoolean()) {
            String msg = "Specifying module-relative paths at project level in the property '" + propKey + "' is deprecated. To continue matching files like '" + filePath + "', update this property so that patterns refer to project-relative paths.";
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
            markAsLogged.run();
        }
    }

    private boolean accept(InputFile indexedFile) {
        for (InputFileFilter filter : this.filters) {
            if (filter.accept(indexedFile)) continue;
            LOG.debug("'{}' excluded by {}", (Object)indexedFile, (Object)filter.getClass().getName());
            return false;
        }
        return true;
    }

    private static String pluralizeFiles(int count) {
        return count == 1 ? "file" : "files";
    }
}

