/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scm.DefaultBlameInput;
import org.sonar.scanner.scm.DefaultBlameOutput;
import org.sonar.scanner.scm.ScmConfiguration;

public final class ScmPublisher {
    private static final Logger LOG = Loggers.get(ScmPublisher.class);
    private final ScmConfiguration configuration;
    private final ProjectRepositories projectRepositories;
    private final InputComponentStore componentStore;
    private final FileSystem fs;
    private final ScannerReportWriter writer;
    private final BranchConfiguration branchConfiguration;

    public ScmPublisher(ScmConfiguration configuration, ProjectRepositories projectRepositories, InputComponentStore componentStore, FileSystem fs, ReportPublisher reportPublisher, BranchConfiguration branchConfiguration) {
        this.configuration = configuration;
        this.projectRepositories = projectRepositories;
        this.componentStore = componentStore;
        this.fs = fs;
        this.branchConfiguration = branchConfiguration;
        this.writer = reportPublisher.getWriter();
    }

    public void publish() {
        if (this.configuration.isDisabled()) {
            LOG.info("SCM Publisher is disabled");
            return;
        }
        ScmProvider provider = this.configuration.provider();
        if (provider == null) {
            LOG.info("No SCM system was detected. You can use the 'sonar.scm.provider' property to explicitly specify it.");
            return;
        }
        List<InputFile> filesToBlame = this.collectFilesToBlame(this.writer);
        if (!filesToBlame.isEmpty()) {
            String key = provider.key();
            LOG.info("SCM provider for this project is: " + key);
            DefaultBlameOutput output = new DefaultBlameOutput(this.writer, filesToBlame);
            try {
                provider.blameCommand().blame(new DefaultBlameInput(this.fs, filesToBlame), output);
            }
            catch (Exception e) {
                output.finish(false);
                throw e;
            }
            output.finish(true);
        }
    }

    private List<InputFile> collectFilesToBlame(ScannerReportWriter writer) {
        if (this.configuration.forceReloadAll()) {
            LOG.warn("Forced reloading of SCM data for all files.");
        }
        LinkedList<InputFile> filesToBlame = new LinkedList<InputFile>();
        for (DefaultInputFile f : this.componentStore.allFilesToPublish()) {
            if (this.configuration.forceReloadAll() || f.status() != InputFile.Status.SAME) {
                ScmPublisher.addIfNotEmpty(filesToBlame, f);
                continue;
            }
            if (this.branchConfiguration.isShortOrPullRequest()) continue;
            FileData fileData = this.projectRepositories.fileData(this.componentStore.findModule(f).getKeyWithBranch(), f);
            if (StringUtils.isEmpty(fileData.revision())) {
                ScmPublisher.addIfNotEmpty(filesToBlame, f);
                continue;
            }
            ScmPublisher.askToCopyDataFromPreviousAnalysis(f, writer);
        }
        return filesToBlame;
    }

    private static void askToCopyDataFromPreviousAnalysis(DefaultInputFile f, ScannerReportWriter writer) {
        ScannerReport.Changesets.Builder scmBuilder = ScannerReport.Changesets.newBuilder();
        scmBuilder.setComponentRef(f.scannerId());
        scmBuilder.setCopyFromPrevious(true);
        writer.writeComponentChangesets(scmBuilder.build());
    }

    private static void addIfNotEmpty(List<InputFile> filesToBlame, InputFile f) {
        if (!f.isEmpty()) {
            filesToBlame.add(f);
        }
    }
}

