/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.sonarqube.ws.client.BaseRequest;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.OkHttpClientBuilder;
import org.sonarqube.ws.client.OkHttpResponse;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class HttpConnector
implements WsConnector {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private final HttpUrl baseUrl;
    private final String systemPassCode;
    private final OkHttpClient okHttpClient;
    private final OkHttpClient noRedirectOkHttpClient;

    private HttpConnector(Builder builder) {
        this.baseUrl = HttpUrl.parse(builder.url.endsWith("/") ? builder.url : String.format("%s/", builder.url));
        Preconditions.checkArgument(this.baseUrl != null, "Malformed URL: '%s'", builder.url);
        OkHttpClientBuilder okHttpClientBuilder = new OkHttpClientBuilder();
        okHttpClientBuilder.setUserAgent(builder.userAgent);
        if (!Strings.isNullOrEmpty(builder.login)) {
            okHttpClientBuilder.setCredentials(Credentials.basic(builder.login, Strings.nullToEmpty(builder.password), StandardCharsets.UTF_8));
        }
        this.systemPassCode = builder.systemPassCode;
        okHttpClientBuilder.setProxy(builder.proxy);
        okHttpClientBuilder.setProxyLogin(builder.proxyLogin);
        okHttpClientBuilder.setProxyPassword(builder.proxyPassword);
        okHttpClientBuilder.setConnectTimeoutMs(builder.connectTimeoutMs);
        okHttpClientBuilder.setReadTimeoutMs(builder.readTimeoutMs);
        okHttpClientBuilder.setSSLSocketFactory(builder.sslSocketFactory);
        okHttpClientBuilder.setTrustManager(builder.sslTrustManager);
        this.okHttpClient = okHttpClientBuilder.build();
        this.noRedirectOkHttpClient = HttpConnector.newClientWithoutRedirect(this.okHttpClient);
    }

    private static OkHttpClient newClientWithoutRedirect(OkHttpClient client) {
        return client.newBuilder().followRedirects(false).followSslRedirects(false).build();
    }

    @Override
    public String baseUrl() {
        return this.baseUrl.url().toExternalForm();
    }

    public OkHttpClient okHttpClient() {
        return this.okHttpClient;
    }

    @Override
    public WsResponse call(WsRequest httpRequest) {
        if (httpRequest instanceof GetRequest) {
            return this.get((GetRequest)httpRequest);
        }
        if (httpRequest instanceof PostRequest) {
            return this.post((PostRequest)httpRequest);
        }
        throw new IllegalArgumentException(String.format("Unsupported implementation: %s", httpRequest.getClass()));
    }

    private WsResponse get(GetRequest getRequest) {
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(getRequest);
        HttpConnector.completeUrlQueryParameters(getRequest, urlBuilder);
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(getRequest, urlBuilder).get();
        return new OkHttpResponse(HttpConnector.doCall(HttpConnector.prepareOkHttpClient(this.okHttpClient, getRequest), okRequestBuilder.build()));
    }

    private WsResponse post(PostRequest postRequest) {
        RequestBody body;
        HttpUrl.Builder urlBuilder = this.prepareUrlBuilder(postRequest);
        Map<String, PostRequest.Part> parts = postRequest.getParts();
        if (parts.isEmpty()) {
            FormBody.Builder formBody = new FormBody.Builder();
            postRequest.getParameters().getKeys().forEach(key -> postRequest.getParameters().getValues((String)key).forEach(value -> formBody.add((String)key, (String)value)));
            body = formBody.build();
        } else {
            HttpConnector.completeUrlQueryParameters(postRequest, urlBuilder);
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            parts.entrySet().forEach(param -> {
                PostRequest.Part part = (PostRequest.Part)param.getValue();
                bodyBuilder.addFormDataPart((String)param.getKey(), part.getFile().getName(), RequestBody.create(MediaType.parse(part.getMediaType()), part.getFile()));
            });
            body = bodyBuilder.build();
        }
        Request.Builder okRequestBuilder = this.prepareOkRequestBuilder(postRequest, urlBuilder).post(body);
        Response response = HttpConnector.doCall(HttpConnector.prepareOkHttpClient(this.noRedirectOkHttpClient, postRequest), okRequestBuilder.build());
        response = this.checkRedirect(response, postRequest);
        return new OkHttpResponse(response);
    }

    private HttpUrl.Builder prepareUrlBuilder(WsRequest wsRequest) {
        String path = wsRequest.getPath();
        return this.baseUrl.resolve(path.startsWith("/") ? path.replaceAll("^(/)+", "") : path).newBuilder();
    }

    private static OkHttpClient prepareOkHttpClient(OkHttpClient okHttpClient, WsRequest wsRequest) {
        if (!wsRequest.getTimeOutInMs().isPresent()) {
            return okHttpClient;
        }
        return okHttpClient.newBuilder().readTimeout(wsRequest.getTimeOutInMs().getAsInt(), TimeUnit.MILLISECONDS).build();
    }

    private static void completeUrlQueryParameters(BaseRequest<?> request, HttpUrl.Builder urlBuilder) {
        request.getParameters().getKeys().forEach(key -> request.getParameters().getValues((String)key).forEach(value -> urlBuilder.addQueryParameter((String)key, (String)value)));
    }

    private Request.Builder prepareOkRequestBuilder(WsRequest getRequest, HttpUrl.Builder urlBuilder) {
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(urlBuilder.build()).header("Accept", getRequest.getMediaType()).header("Accept-Charset", "UTF-8");
        if (this.systemPassCode != null) {
            okHttpRequestBuilder.header("X-Sonar-Passcode", this.systemPassCode);
        }
        getRequest.getHeaders().getNames().forEach(name -> okHttpRequestBuilder.header((String)name, getRequest.getHeaders().getValue((String)name).get()));
        return okHttpRequestBuilder;
    }

    private static Response doCall(OkHttpClient client, Request okRequest) {
        Call call = client.newCall(okRequest);
        try {
            return call.execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request " + okRequest.url(), e);
        }
    }

    private Response checkRedirect(Response response, PostRequest postRequest) {
        switch (response.code()) {
            case 301: 
            case 302: 
            case 307: 
            case 308: {
                return this.followPostRedirect(response, postRequest);
            }
        }
        return response;
    }

    private Response followPostRedirect(Response response, PostRequest postRequest) {
        String location = response.header("Location");
        if (location == null) {
            throw new IllegalStateException(String.format("Missing HTTP header 'Location' in redirect of %s", response.request().url()));
        }
        HttpUrl url = response.request().url().resolve(location);
        if (url == null) {
            throw new IllegalStateException(String.format("Unsupported protocol in redirect of %s to %s", response.request().url(), location));
        }
        Request.Builder redirectRequest = response.request().newBuilder();
        redirectRequest.post(response.request().body());
        response.body().close();
        return HttpConnector.doCall(HttpConnector.prepareOkHttpClient(this.noRedirectOkHttpClient, postRequest), redirectRequest.url(url).build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String userAgent;
        private String login;
        private String password;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private String systemPassCode;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager sslTrustManager = null;

        private Builder() {
        }

        public Builder userAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder credentials(@Nullable String login, @Nullable String password) {
            this.login = login;
            this.password = password;
            return this;
        }

        public Builder token(@Nullable String token) {
            this.login = token;
            this.password = null;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder setSSLSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder setTrustManager(@Nullable X509TrustManager sslTrustManager) {
            this.sslTrustManager = sslTrustManager;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyCredentials(@Nullable String proxyLogin, @Nullable String proxyPassword) {
            this.proxyLogin = proxyLogin;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder systemPassCode(@Nullable String systemPassCode) {
            this.systemPassCode = systemPassCode;
            return this;
        }

        public HttpConnector build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.url), "Server URL is not defined");
            return new HttpConnector(this);
        }
    }
}

