/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.authentication;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.user.UserGroupValidation;

@Immutable
public final class UserIdentity {
    @Nullable
    private final String id;
    private final String providerLogin;
    @Nullable
    private final String login;
    private final String name;
    @Nullable
    private final String email;
    private final boolean groupsProvided;
    private final Set<String> groups;

    private UserIdentity(Builder builder) {
        this.id = builder.id;
        this.providerLogin = builder.providerLogin;
        this.login = builder.login;
        this.name = builder.name;
        this.email = builder.email;
        this.groupsProvided = builder.groupsProvided;
        this.groups = builder.groups;
    }

    @CheckForNull
    public String getProviderId() {
        return this.id;
    }

    public String getProviderLogin() {
        return this.providerLogin;
    }

    @CheckForNull
    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getEmail() {
        return this.email;
    }

    public boolean shouldSyncGroups() {
        return this.groupsProvided;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String providerLogin;
        private String login;
        private String name;
        private String email;
        private boolean groupsProvided = false;
        private Set<String> groups = new HashSet<String>();

        private Builder() {
        }

        public Builder setProviderId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public Builder setProviderLogin(String providerLogin) {
            this.providerLogin = providerLogin;
            return this;
        }

        public Builder setLogin(@Nullable String login) {
            this.login = login;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setGroups(Set<String> groups) {
            Objects.requireNonNull(groups, "Groups cannot be null, please don't use this method if groups should not be synchronized.");
            groups.forEach(UserGroupValidation::validateGroupName);
            this.groupsProvided = true;
            this.groups = groups;
            return this;
        }

        public UserIdentity build() {
            Builder.validateId(this.id);
            Builder.validateProviderLogin(this.providerLogin);
            Builder.validateLogin(this.login);
            Builder.validateName(this.name);
            Builder.validateEmail(this.email);
            return new UserIdentity(this);
        }

        private static void validateId(@Nullable String id) {
            Preconditions.checkArgument(id == null || id.length() <= 255, "ID is too big (255 characters max)");
        }

        private static void validateProviderLogin(String providerLogin) {
            Preconditions.checkArgument(StringUtils.isNotBlank(providerLogin), "Provider login must not be blank");
            Preconditions.checkArgument(providerLogin.length() <= 255, "Provider login size is incorrect (maximum 255 characters)");
        }

        private static void validateLogin(@Nullable String login) {
            Preconditions.checkArgument(StringUtils.isBlank(login) || login.length() <= 255 && login.length() >= 2, "User login size is incorrect (Between 2 and 255 characters)");
        }

        private static void validateName(String name) {
            Preconditions.checkArgument(StringUtils.isNotBlank(name), "User name must not be blank");
            Preconditions.checkArgument(name.length() <= 200, "User name size is too big (200 characters max)");
        }

        private static void validateEmail(@Nullable String email) {
            Preconditions.checkArgument(email == null || email.length() <= 100, "User email size is too big (100 characters max)");
        }
    }
}

