/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.commonruleengine.EngineContext;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.Metrics;
import org.sonar.commonruleengine.MetricsVisitor;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.Visitor;
import org.sonar.uast.validators.Validator;

public class Engine {
    private final EngineContext engineContext;
    private final MetricsVisitor metricsVisitor;

    public Engine(Collection<Check> rules) {
        this(rules, Validator.all());
    }

    public Engine(Collection<Check> rules, Collection<Validator> validators) {
        this.engineContext = new EngineContext(rules);
        this.metricsVisitor = new MetricsVisitor();
        validators.forEach(rule -> rule.initialize(this.engineContext));
        rules.forEach(rule -> rule.initialize(this.engineContext));
    }

    public ScanResult scan(UastNode uast, InputFile inputFile) throws IOException {
        this.metricsVisitor.enterFile(uast);
        this.engineContext.enterFile(inputFile);
        this.visit(uast);
        return new ScanResult(this.engineContext.getIssues(), this.metricsVisitor.getMetrics());
    }

    private void visit(UastNode uast) {
        this.metricsVisitor.visitNode(uast);
        Set visitors = uast.kinds.stream().flatMap(kind -> this.engineContext.registeredVisitors((UastNode.Kind)kind).stream()).collect(Collectors.toSet());
        for (Visitor visitor : visitors) {
            visitor.visitNode(uast);
        }
        for (UastNode child : uast.children) {
            this.visit(child);
        }
        for (Visitor visitor : visitors) {
            visitor.leaveNode(uast);
        }
    }

    public static class ScanResult {
        public final List<Issue> issues;
        public final Metrics metrics;

        public ScanResult(List<Issue> issues, Metrics metrics) {
            this.issues = issues;
            this.metrics = metrics;
        }
    }
}

