/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.SyntacticEquivalence;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.BinaryExpressionLike;

@Rule(key="S1764")
public class BinaryOperatorIdenticalExpressionsCheck
extends Check {
    public BinaryOperatorIdenticalExpressionsCheck() {
        super(UastNode.Kind.BINARY_EXPRESSION);
    }

    @Override
    public void visitNode(UastNode node) {
        BinaryExpressionLike binaryExpression = BinaryExpressionLike.from(node);
        if (binaryExpression != null && !BinaryOperatorIdenticalExpressionsCheck.isExcluded(binaryExpression) && SyntacticEquivalence.areEquivalent(binaryExpression.leftOperand(), binaryExpression.rightOperand())) {
            String operator = binaryExpression.operator().joinTokens();
            this.reportIssue(binaryExpression.rightOperand(), "Correct one of the identical sub-expressions on both sides of operator \"" + operator + "\".", new Issue.Message(binaryExpression.leftOperand()));
        }
    }

    private static boolean isExcluded(BinaryExpressionLike binaryExpression) {
        return binaryExpression.operator().is(UastNode.Kind.ASSIGNMENT_OPERATOR) || binaryExpression.node().is(UastNode.Kind.ADD, UastNode.Kind.MULTIPLY, UastNode.Kind.LEFT_SHIFT);
    }
}

