/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1066")
public class CollapsibleIfCheck
extends Check {
    private static final String MESSAGE = "Merge this if statement with the nested one.";

    public CollapsibleIfCheck() {
        super(UastNode.Kind.IF);
    }

    @Override
    public void visitNode(UastNode node) {
        List<UastNode> bodyStatementChildren;
        if (!CollapsibleIfCheck.hasElse(node) && (bodyStatementChildren = node.getChildren(UastNode.Kind.STATEMENT, UastNode.Kind.BLOCK)).size() == 1) {
            List<UastNode> nestedInBlockOptionalStatement;
            UastNode statementNode = bodyStatementChildren.get(0);
            if (statementNode.is(UastNode.Kind.BLOCK) && (nestedInBlockOptionalStatement = statementNode.getChildren(UastNode.Kind.STATEMENT)).size() == 1) {
                statementNode = nestedInBlockOptionalStatement.get(0);
            }
            if (statementNode.is(UastNode.Kind.IF) && !CollapsibleIfCheck.hasElse(statementNode) && CollapsibleIfCheck.hasSimpleCondition(statementNode)) {
                this.reportIssue(CollapsibleIfCheck.getReportingLocationForIf(node), MESSAGE, new Issue.Message(CollapsibleIfCheck.getReportingLocationForIf(statementNode), "Nested \"if\" statement"));
            }
        }
    }

    private static boolean hasSimpleCondition(UastNode ifStatementNode) {
        Optional<UastNode> condition = ifStatementNode.getChild(UastNode.Kind.CONDITION);
        return condition.isPresent() && !condition.get().getChild(UastNode.Kind.STATEMENT).isPresent();
    }

    private static boolean hasElse(UastNode node) {
        return !node.getChildren(UastNode.Kind.ELSE).isEmpty();
    }

    private static UastNode getReportingLocationForIf(UastNode ifStatementNode) {
        return ifStatementNode.getChild(UastNode.Kind.IF_KEYWORD).orElse(ifStatementNode);
    }
}

