/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S108")
public class EmptyBlockCheck
extends Check {
    private static final String MESSAGE = "Either remove or fill this block of code.";
    private Set<UastNode> functionBlocks = new HashSet<UastNode>();
    private Set<UastNode> forAndSelectBlocks = new HashSet<UastNode>();

    public EmptyBlockCheck() {
        super(UastNode.Kind.SWITCH, UastNode.Kind.BLOCK, UastNode.Kind.FUNCTION, UastNode.Kind.FUNCTION_LITERAL, UastNode.Kind.STATEMENT);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        this.functionBlocks.clear();
        this.forAndSelectBlocks.clear();
    }

    @Override
    public void visitNode(UastNode node) {
        if (node.is(UastNode.Kind.STATEMENT)) {
            UastNode.Token firstToken = node.firstToken();
            if (firstToken != null && firstToken.value.equals("select")) {
                this.forAndSelectBlocks.addAll(node.getChildren(UastNode.Kind.BLOCK));
            }
            if (node.is(UastNode.Kind.FOR, UastNode.Kind.FOREACH)) {
                this.forAndSelectBlocks.addAll(node.getChildren(UastNode.Kind.BLOCK));
            }
        }
        if (node.is(UastNode.Kind.FUNCTION, UastNode.Kind.FUNCTION_LITERAL)) {
            List<UastNode> children = node.getChildren(UastNode.Kind.BLOCK);
            this.functionBlocks.addAll(children);
        }
        if (node.is(UastNode.Kind.BLOCK, UastNode.Kind.SWITCH) && !this.functionBlocks.contains(node) && !EmptyBlockCheck.hasSomethingBetweenBraces(node)) {
            if (this.forAndSelectBlocks.contains(node)) {
                return;
            }
            this.reportIssue(node, MESSAGE);
        }
    }

    private static boolean hasSomethingBetweenBraces(UastNode node) {
        boolean insideBraces = false;
        boolean hasBraces = false;
        for (UastNode child : node.children) {
            if (child.token != null && child.token.value.equals("{")) {
                insideBraces = true;
                hasBraces = true;
                continue;
            }
            if (child.token != null && child.token.value.equals("}")) {
                insideBraces = false;
                continue;
            }
            if (!insideBraces) continue;
            return true;
        }
        return !hasBraces;
    }
}

