/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.LiteralLike;

@Rule(key="S1313")
public class HardcodedIpAddressCheck
extends Check {
    private static final Pattern IPV4_PATTERN = Pattern.compile("([^\\d.]*\\/)?(?<ip>(?:\\d{1,3}\\.){3}\\d{1,3}(?!\\d|\\.))(:(\\d{1,5}))?(\\/.*)?");

    public HardcodedIpAddressCheck() {
        super(UastNode.Kind.STRING_LITERAL);
    }

    @Override
    public void visitNode(UastNode node) {
        String ip;
        LiteralLike literal = LiteralLike.from(node);
        String content = HardcodedIpAddressCheck.removeQuotes(literal.value());
        Matcher ipv4Matcher = IPV4_PATTERN.matcher(content);
        if (ipv4Matcher.matches() && HardcodedIpAddressCheck.isValidIpAddress(ip = ipv4Matcher.group("ip"))) {
            this.reportIssue(literal.node(), "Make this IP \"" + ip + "\" address configurable.");
        }
    }

    private static String removeQuotes(String string) {
        if (string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static boolean isValidIpAddress(String ip) {
        return Arrays.stream(ip.split("\\.")).mapToInt(Integer::parseInt).noneMatch(num -> num > 255);
    }
}

