/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.LiteralLike;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
extends Check {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 7;
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;
    private final Map<String, List<UastNode>> occurrences = new HashMap<String, List<UastNode>>();

    public StringLiteralDuplicatedCheck() {
        super(UastNode.Kind.STRING_LITERAL, UastNode.Kind.COMPILATION_UNIT);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        this.occurrences.clear();
        super.enterFile(inputFile);
    }

    @Override
    public void visitNode(UastNode node) {
        String literalValue;
        LiteralLike literal = LiteralLike.from(node);
        if (literal != null && (literalValue = literal.value()).length() > 7) {
            List occurrenceList = this.occurrences.computeIfAbsent(literalValue, key -> new ArrayList());
            occurrenceList.add(node);
        }
    }

    @Override
    public void leaveNode(UastNode node) {
        if (node.is(UastNode.Kind.COMPILATION_UNIT)) {
            this.occurrences.values().stream().filter(nodes -> nodes.size() >= this.threshold).forEach(nodes -> {
                UastNode firstNode = (UastNode)nodes.iterator().next();
                this.reportIssue(firstNode, firstNode, "Define a constant instead of duplicating this literal " + nodes.size() + " times.", nodes.size(), this.secondaryMessages((List<UastNode>)nodes));
            });
        }
    }

    private Issue.Message[] secondaryMessages(List<UastNode> nodes) {
        return (Issue.Message[])nodes.stream().skip(1L).map(node -> new Issue.Message((UastNode)node, "Duplication")).toArray(Issue.Message[]::new);
    }
}

