/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.SwitchLike;

@Rule(key="S131")
public class SwitchWithoutDefaultCheck
extends Check {
    public SwitchWithoutDefaultCheck() {
        super(UastNode.Kind.SWITCH);
    }

    @Override
    public void visitNode(UastNode node) {
        SwitchLike switchNode = SwitchLike.from(node);
        if (switchNode.caseNodes().stream().noneMatch(UastNode.Kind.DEFAULT_CASE)) {
            this.reportIssue(switchNode.switchKeyword(), "Add a default case to this switch.");
        }
    }
}

