/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.FunctionLike;

@Rule(key="S107")
public class TooManyParametersCheck
extends Check {
    private static final int DEFAULT_MAXIMUM = 7;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="7")
    public int maximum = 7;

    public TooManyParametersCheck() {
        super(UastNode.Kind.FUNCTION);
    }

    @Override
    public void visitNode(UastNode node) {
        FunctionLike function = FunctionLike.from(node);
        if (function == null) {
            return;
        }
        List<UastNode> parameters = function.parameters();
        int parameterCount = 0;
        for (UastNode parameter : parameters) {
            ArrayList identifiers = new ArrayList();
            parameter.getDescendants(UastNode.Kind.IDENTIFIER, identifiers::add, UastNode.Kind.TYPE);
            parameterCount += identifiers.size();
        }
        if (parameterCount > this.maximum) {
            this.reportIssue(function.name(), String.format("Function has %d parameters, which is more than %d authorized.", parameterCount, this.maximum));
        }
    }
}

