/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1751")
public class UnconditionalJumpStatementCheck
extends Check {
    private static final UastNode.Kind[] JUMP_KINDS = new UastNode.Kind[]{UastNode.Kind.BREAK, UastNode.Kind.RETURN, UastNode.Kind.THROW, UastNode.Kind.CONTINUE};

    public UnconditionalJumpStatementCheck() {
        super(UastNode.Kind.LOOP);
    }

    @Override
    public void visitNode(UastNode node) {
        if (node.is(UastNode.Kind.FOREACH)) {
            return;
        }
        Optional<UastNode> blockOptional = node.children.stream().filter(UastNode.Kind.BLOCK).findFirst();
        if (blockOptional.isPresent()) {
            this.findUnconditionalJump(blockOptional.get());
        } else {
            node.children.stream().filter(UastNode.Kind.STATEMENT).findFirst().filter(n -> n.is(JUMP_KINDS)).ifPresent(this::reportIssue);
        }
    }

    private void findUnconditionalJump(UastNode block) {
        for (UastNode statement : block.children) {
            if (statement.is(UastNode.Kind.CONTINUE)) {
                this.reportIssue(statement);
                return;
            }
            if (statement.hasDescendant(UastNode.Kind.CONTINUE)) {
                return;
            }
            if (!statement.is(JUMP_KINDS)) continue;
            this.reportIssue(statement);
            return;
        }
    }

    private void reportIssue(UastNode statement) {
        this.reportIssue(statement, "Remove this unconditional jump or make it conditional.");
    }
}

