/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.AssignmentLike;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
extends Check {
    public WrongAssignmentOperatorCheck() {
        super(UastNode.Kind.ASSIGNMENT);
    }

    @Override
    public void visitNode(UastNode node) {
        AssignmentLike assignmentLike = AssignmentLike.from(node);
        if (assignmentLike == null) {
            return;
        }
        if (assignmentLike.isMultiple()) {
            List<AssignmentLike> couples = assignmentLike.assignmentsTuples();
            if (couples.size() != 1) {
                return;
            }
            assignmentLike = couples.get(0);
        }
        UastNode.Token variableLastToken = assignmentLike.target().lastToken();
        UastNode operator = assignmentLike.operator();
        UastNode expression = assignmentLike.value();
        UastNode.Token expressionFirstToken = expression.firstToken();
        if (WrongAssignmentOperatorCheck.noSpacingBetween(operator.lastToken(), expressionFirstToken) && WrongAssignmentOperatorCheck.spacingBetween(variableLastToken, operator.firstToken()) && expression.is(UastNode.Kind.UNARY_MINUS, UastNode.Kind.UNARY_PLUS, UastNode.Kind.LOGICAL_COMPLEMENT)) {
            String msg = expression.is(UastNode.Kind.LOGICAL_COMPLEMENT) ? "Add a space between \"=\" and \"!\" to avoid confusion." : String.format("Was \"%s=\" meant instead?", expressionFirstToken.value);
            this.reportIssue(assignmentLike.node(), msg);
        }
    }

    private static boolean spacingBetween(UastNode.Token firstToken, UastNode.Token secondToken) {
        return !WrongAssignmentOperatorCheck.noSpacingBetween(firstToken, secondToken);
    }

    private static boolean noSpacingBetween(UastNode.Token firstToken, UastNode.Token secondToken) {
        return firstToken.line == secondToken.line && firstToken.endColumn + 1 == secondToken.column;
    }
}

