/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class GoPathContext {
    private static final String LINUX_ABSOLUTE_PREFIX = "_/";
    private static final String WINDOWS_ABSOLUTE_PREFIX = "_\\";
    private static final Pattern WINDOWS_ABSOLUTE_REGEX = Pattern.compile("^_\\\\(\\w)_\\\\");
    private static final int MAX_PATH_CACHE_SIZE = 100;
    static final GoPathContext DEFAULT = new GoPathContext(File.separatorChar, File.pathSeparator, System.getenv("GOPATH"));
    final char fileSeparator;
    final List<String> goSrcPathList;
    final Map<String, String> resolvedPaths = new LinkedHashMap<String, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    };

    GoPathContext(char fileSeparator, String pathSeparator, @Nullable String goPath) {
        this.fileSeparator = fileSeparator;
        List<Object> goPathEntries = Collections.emptyList();
        if (goPath != null) {
            goPathEntries = Arrays.asList(goPath.split(pathSeparator));
        }
        this.goSrcPathList = goPathEntries.stream().filter(path -> !path.isEmpty()).map(path -> this.concat((String)path, "src")).collect(Collectors.toList());
    }

    String concat(String parentPath, String childPath) {
        if (parentPath.isEmpty() || parentPath.charAt(parentPath.length() - 1) == this.fileSeparator) {
            return parentPath + childPath;
        }
        return parentPath + this.fileSeparator + childPath;
    }

    String resolve(String filePath) {
        return this.resolvedPaths.computeIfAbsent(filePath, path -> {
            Matcher matcher;
            if (path.startsWith(LINUX_ABSOLUTE_PREFIX)) {
                return path.substring(1);
            }
            if (path.startsWith(WINDOWS_ABSOLUTE_PREFIX) && (matcher = WINDOWS_ABSOLUTE_REGEX.matcher((CharSequence)path)).find()) {
                matcher.reset();
                return matcher.replaceFirst("$1:\\\\");
            }
            return this.prefixByFirstValidGoPath((String)path).orElseGet(() -> this.prefixByFirstGoPath((String)path));
        });
    }

    private Optional<String> prefixByFirstValidGoPath(String filePath) {
        return this.goSrcPathList.stream().map(goPath -> this.concat((String)goPath, filePath)).filter(path -> new File((String)path).exists()).findFirst();
    }

    private String prefixByFirstGoPath(String filePath) {
        if (this.goSrcPathList.isEmpty()) {
            return filePath;
        }
        return this.concat(this.goSrcPathList.get(0), filePath);
    }
}

