/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.commonruleengine.Engine;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.Metrics;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.go.plugin.CpdVisitor;
import org.sonar.go.plugin.GoChecks;
import org.sonar.go.plugin.GoCoverageReport;
import org.sonar.go.plugin.GoPathContext;
import org.sonar.go.plugin.HighlightingVisitor;
import org.sonar.go.plugin.UastGeneratorWrapper;
import org.sonar.go.plugin.utils.PluginApiUtils;
import org.sonar.uast.UastNode;
import org.sonar.uast.validators.Validator;

public class GoSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(GoSensor.class);
    private final Checks<Check> checks;
    private final FileLinesContextFactory fileLinesContextFactory;

    public GoSensor(CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory) {
        this.checks = checkFactory.create("go").addAnnotatedChecks(GoChecks.getChecks());
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("go").name("SonarGo");
    }

    public void execute(SensorContext context) {
        UastGeneratorWrapper uastGenerator;
        Engine ruleEngine = new Engine(this.checks.all());
        try {
            uastGenerator = new UastGeneratorWrapper(context);
        }
        catch (Exception e) {
            LOG.error("Error initializing UAST generator", (Throwable)e);
            return;
        }
        for (InputFile inputFile : GoSensor.getInputFiles(context)) {
            try {
                InputStream inputStream = inputFile.inputStream();
                Throwable throwable = null;
                try {
                    UastNode uast = uastGenerator.createUast(inputStream);
                    if (inputFile.type() == InputFile.Type.MAIN) {
                        Engine.ScanResult scanResult = ruleEngine.scan(uast, inputFile);
                        scanResult.issues.forEach(issue -> this.reportIssue((Issue)issue, context, inputFile));
                        this.saveMetrics(scanResult.metrics, context, inputFile);
                        GoSensor.saveCpdTokens(uast, context, inputFile);
                    }
                    GoSensor.saveHighlighting(uast, context, inputFile);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Validator.ValidationException e) {
                LOG.error("Unable to validate UAST of file " + inputFile.toString(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Error analyzing file " + inputFile.toString(), (Throwable)e);
            }
        }
        try {
            GoCoverageReport.saveCoverageReports(context, GoPathContext.DEFAULT);
        }
        catch (Exception e) {
            LOG.error("Coverage import failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void reportIssue(Issue issue, SensorContext context, InputFile inputFile) {
        RuleKey ruleKey = this.checks.ruleKey((Object)issue.getCheck());
        Objects.requireNonNull(ruleKey, "Rule key not found for " + issue.getCheck().getClass());
        NewIssue newIssue = context.newIssue();
        NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).message(issue.getMessage());
        if (issue.hasNodeLocation()) {
            location.at(PluginApiUtils.newRange(inputFile, issue.getPrimary().from, issue.getPrimary().to));
        } else if (issue.hasLineLocation()) {
            location.at(inputFile.selectLine(issue.getPrimary().line.intValue()));
        }
        newIssue.forRule(ruleKey).at(location).gap(issue.getEffortToFix());
        Arrays.stream(issue.getSecondaries()).forEach(secondary -> newIssue.addLocation(newIssue.newLocation().on((InputComponent)inputFile).at(PluginApiUtils.newRange(inputFile, secondary.from, secondary.to)).message(secondary.description == null ? "" : secondary.description)));
        newIssue.save();
    }

    private void saveMetrics(Metrics metrics, SensorContext context, InputFile inputFile) {
        GoSensor.saveMetric(context, inputFile, CoreMetrics.NCLOC, metrics.linesOfCode.size());
        GoSensor.saveMetric(context, inputFile, CoreMetrics.COMMENT_LINES, metrics.commentLines.size());
        GoSensor.saveMetric(context, inputFile, CoreMetrics.CLASSES, metrics.numberOfClasses);
        GoSensor.saveMetric(context, inputFile, CoreMetrics.FUNCTIONS, metrics.numberOfFunctions);
        GoSensor.saveMetric(context, inputFile, CoreMetrics.STATEMENTS, metrics.numberOfStatements);
        GoSensor.saveMetric(context, inputFile, CoreMetrics.COGNITIVE_COMPLEXITY, metrics.cognitiveComplexity);
        FileLinesContext linesContext = this.fileLinesContextFactory.createFor(inputFile);
        GoSensor.saveLinesMetrics(linesContext, metrics.linesOfCode, "ncloc_data");
        GoSensor.saveLinesMetrics(linesContext, metrics.commentLines, "comment_lines_data");
        GoSensor.saveLinesMetrics(linesContext, metrics.executableLines, "executable_lines_data");
        linesContext.save();
    }

    private static void saveLinesMetrics(FileLinesContext linesContext, Set<Integer> lines, String metricKey) {
        lines.forEach(line -> linesContext.setIntValue(metricKey, line.intValue(), 1));
    }

    private static void saveHighlighting(UastNode uast, SensorContext context, InputFile inputFile) {
        HighlightingVisitor highlighting = new HighlightingVisitor(context, inputFile);
        highlighting.scan(uast);
        highlighting.save();
    }

    private static void saveCpdTokens(UastNode uast, SensorContext context, InputFile inputFile) {
        CpdVisitor cpdVisitor = new CpdVisitor(context, inputFile);
        cpdVisitor.scan(uast);
        cpdVisitor.save();
    }

    private static <T extends Serializable> void saveMetric(SensorContext context, InputFile inputFile, Metric<T> metric, T value) {
        context.newMeasure().on((InputComponent)inputFile).forMetric(metric).withValue(value).save();
    }

    private static Iterable<InputFile> getInputFiles(SensorContext context) {
        FileSystem fs = context.fileSystem();
        return fs.inputFiles(fs.predicates().hasLanguage("go"));
    }

    static class GoPluginException
    extends RuntimeException {
        public GoPluginException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

