/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin.externalreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.plugin.externalreport.AbstractReportSensor;
import org.sonar.go.plugin.externalreport.ExternalIssue;
import org.sonar.go.plugin.externalreport.GoVetReportSensor;

public class GoLintReportSensor
extends AbstractReportSensor {
    private static final Logger LOG = Loggers.get(GoVetReportSensor.class);
    public static final String PROPERTY_KEY = "sonar.go.golint.reportPaths";
    private static final Pattern GO_LINT_LINE_REGEX = Pattern.compile("(?<file>[^:]+):(?<line>\\d+):\\d*:(?<message>.*)");
    public static final String LINTER_ID = "golint";
    public static final String LINTER_NAME = "Golint";

    @Override
    String linterName() {
        return LINTER_NAME;
    }

    @Override
    String reportsPropertyName() {
        return PROPERTY_KEY;
    }

    @Override
    @Nullable
    ExternalIssue parse(String line) {
        Matcher matcher = GO_LINT_LINE_REGEX.matcher(line);
        if (matcher.matches()) {
            String filename = matcher.group("file").trim();
            int lineNumber = Integer.parseInt(matcher.group("line").trim());
            String message = matcher.group("message").trim();
            return new ExternalIssue(LINTER_ID, RuleType.CODE_SMELL, null, filename, lineNumber, message);
        }
        LOG.debug(this.logPrefix() + "Unexpected line: " + line);
        return null;
    }
}

